package io.fabric8.openshift.api.model.console.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConsoleSampleSpecFluent<A extends ConsoleSampleSpecFluent<A>> extends BaseFluent<A>{
  public ConsoleSampleSpecFluent() {
  }
  
  public ConsoleSampleSpecFluent(ConsoleSampleSpec instance) {
    this.copyInstance(instance);
  }
  private String _abstract;
  private String description;
  private String icon;
  private String provider;
  private ConsoleSampleSourceBuilder source;
  private List<String> tags = new ArrayList<String>();
  private String title;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ConsoleSampleSpec instance) {
    instance = (instance != null ? instance : new ConsoleSampleSpec());
    if (instance != null) {
          this.withAbstract(instance.getAbstract());
          this.withDescription(instance.getDescription());
          this.withIcon(instance.getIcon());
          this.withProvider(instance.getProvider());
          this.withSource(instance.getSource());
          this.withTags(instance.getTags());
          this.withTitle(instance.getTitle());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAbstract() {
    return this._abstract;
  }
  
  public A withAbstract(String _abstract) {
    this._abstract = _abstract;
    return (A) this;
  }
  
  public boolean hasAbstract() {
    return this._abstract != null;
  }
  
  public String getDescription() {
    return this.description;
  }
  
  public A withDescription(String description) {
    this.description = description;
    return (A) this;
  }
  
  public boolean hasDescription() {
    return this.description != null;
  }
  
  public String getIcon() {
    return this.icon;
  }
  
  public A withIcon(String icon) {
    this.icon = icon;
    return (A) this;
  }
  
  public boolean hasIcon() {
    return this.icon != null;
  }
  
  public String getProvider() {
    return this.provider;
  }
  
  public A withProvider(String provider) {
    this.provider = provider;
    return (A) this;
  }
  
  public boolean hasProvider() {
    return this.provider != null;
  }
  
  public ConsoleSampleSource buildSource() {
    return this.source != null ? this.source.build() : null;
  }
  
  public A withSource(ConsoleSampleSource source) {
    this._visitables.remove("source");
    if (source != null) {
        this.source = new ConsoleSampleSourceBuilder(source);
        this._visitables.get("source").add(this.source);
    } else {
        this.source = null;
        this._visitables.get("source").remove(this.source);
    }
    return (A) this;
  }
  
  public boolean hasSource() {
    return this.source != null;
  }
  
  public SourceNested<A> withNewSource() {
    return new SourceNested(null);
  }
  
  public SourceNested<A> withNewSourceLike(ConsoleSampleSource item) {
    return new SourceNested(item);
  }
  
  public SourceNested<A> editSource() {
    return withNewSourceLike(java.util.Optional.ofNullable(buildSource()).orElse(null));
  }
  
  public SourceNested<A> editOrNewSource() {
    return withNewSourceLike(java.util.Optional.ofNullable(buildSource()).orElse(new ConsoleSampleSourceBuilder().build()));
  }
  
  public SourceNested<A> editOrNewSourceLike(ConsoleSampleSource item) {
    return withNewSourceLike(java.util.Optional.ofNullable(buildSource()).orElse(item));
  }
  
  public A addToTags(int index,String item) {
    if (this.tags == null) {this.tags = new ArrayList<String>();}
    this.tags.add(index, item);
    return (A)this;
  }
  
  public A setToTags(int index,String item) {
    if (this.tags == null) {this.tags = new ArrayList<String>();}
    this.tags.set(index, item); return (A)this;
  }
  
  public A addToTags(java.lang.String... items) {
    if (this.tags == null) {this.tags = new ArrayList<String>();}
    for (String item : items) {this.tags.add(item);} return (A)this;
  }
  
  public A addAllToTags(Collection<String> items) {
    if (this.tags == null) {this.tags = new ArrayList<String>();}
    for (String item : items) {this.tags.add(item);} return (A)this;
  }
  
  public A removeFromTags(java.lang.String... items) {
    if (this.tags == null) return (A)this;
    for (String item : items) { this.tags.remove(item);} return (A)this;
  }
  
  public A removeAllFromTags(Collection<String> items) {
    if (this.tags == null) return (A)this;
    for (String item : items) { this.tags.remove(item);} return (A)this;
  }
  
  public List<String> getTags() {
    return this.tags;
  }
  
  public String getTag(int index) {
    return this.tags.get(index);
  }
  
  public String getFirstTag() {
    return this.tags.get(0);
  }
  
  public String getLastTag() {
    return this.tags.get(tags.size() - 1);
  }
  
  public String getMatchingTag(Predicate<String> predicate) {
      for (String item : tags) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingTag(Predicate<String> predicate) {
      for (String item : tags) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTags(List<String> tags) {
    if (tags != null) {
        this.tags = new ArrayList();
        for (String item : tags) {
          this.addToTags(item);
        }
    } else {
      this.tags = null;
    }
    return (A) this;
  }
  
  public A withTags(java.lang.String... tags) {
    if (this.tags != null) {
        this.tags.clear();
        _visitables.remove("tags");
    }
    if (tags != null) {
      for (String item : tags) {
        this.addToTags(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTags() {
    return this.tags != null && !this.tags.isEmpty();
  }
  
  public String getTitle() {
    return this.title;
  }
  
  public A withTitle(String title) {
    this.title = title;
    return (A) this;
  }
  
  public boolean hasTitle() {
    return this.title != null;
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConsoleSampleSpecFluent that = (ConsoleSampleSpecFluent) o;
    if (!java.util.Objects.equals(_abstract, that._abstract)) return false;
    if (!java.util.Objects.equals(description, that.description)) return false;
    if (!java.util.Objects.equals(icon, that.icon)) return false;
    if (!java.util.Objects.equals(provider, that.provider)) return false;
    if (!java.util.Objects.equals(source, that.source)) return false;
    if (!java.util.Objects.equals(tags, that.tags)) return false;
    if (!java.util.Objects.equals(title, that.title)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(_abstract,  description,  icon,  provider,  source,  tags,  title,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (_abstract != null) { sb.append("_abstract:"); sb.append(_abstract + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (icon != null) { sb.append("icon:"); sb.append(icon + ","); }
    if (provider != null) { sb.append("provider:"); sb.append(provider + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (tags != null && !tags.isEmpty()) { sb.append("tags:"); sb.append(tags + ","); }
    if (title != null) { sb.append("title:"); sb.append(title + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SourceNested<N> extends ConsoleSampleSourceFluent<SourceNested<N>> implements Nested<N>{
    SourceNested(ConsoleSampleSource item) {
      this.builder = new ConsoleSampleSourceBuilder(this, item);
    }
    ConsoleSampleSourceBuilder builder;
    
    public N and() {
      return (N) ConsoleSampleSpecFluent.this.withSource(builder.build());
    }
    
    public N endSource() {
      return and();
    }
    
  
  }

}