/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.config.v1.EtcdStorageConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class EtcdStorageConfigFluent<A extends EtcdStorageConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String ca;
    private String certFile;
    private String keyFile;
    private String storagePrefix;
    private List<String> urls = new ArrayList<String>();

    public EtcdStorageConfigFluent() {
    }

    public EtcdStorageConfigFluent(EtcdStorageConfig instance) {
        this.copyInstance(instance);
    }

    public A addAllToUrls(Collection<String> items) {
        if (this.urls == null) {
            this.urls = new ArrayList<String>();
        }
        for (String item : items) {
            this.urls.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToUrls(String ... items) {
        if (this.urls == null) {
            this.urls = new ArrayList<String>();
        }
        for (String item : items) {
            this.urls.add(item);
        }
        return (A)((Object)this);
    }

    public A addToUrls(int index, String item) {
        if (this.urls == null) {
            this.urls = new ArrayList<String>();
        }
        this.urls.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(EtcdStorageConfig instance) {
        EtcdStorageConfig etcdStorageConfig = instance = instance != null ? instance : new EtcdStorageConfig();
        if (instance != null) {
            this.withCa(instance.getCa());
            this.withCertFile(instance.getCertFile());
            this.withKeyFile(instance.getKeyFile());
            this.withStoragePrefix(instance.getStoragePrefix());
            this.withUrls(instance.getUrls());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EtcdStorageConfigFluent that = (EtcdStorageConfigFluent)((Object)o);
        if (!Objects.equals(this.ca, that.ca)) {
            return false;
        }
        if (!Objects.equals(this.certFile, that.certFile)) {
            return false;
        }
        if (!Objects.equals(this.keyFile, that.keyFile)) {
            return false;
        }
        if (!Objects.equals(this.storagePrefix, that.storagePrefix)) {
            return false;
        }
        if (!Objects.equals(this.urls, that.urls)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getCa() {
        return this.ca;
    }

    public String getCertFile() {
        return this.certFile;
    }

    public String getFirstUrl() {
        return this.urls.get(0);
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public String getLastUrl() {
        return this.urls.get(this.urls.size() - 1);
    }

    public String getMatchingUrl(Predicate<String> predicate) {
        for (String item : this.urls) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getStoragePrefix() {
        return this.storagePrefix;
    }

    public String getUrl(int index) {
        return this.urls.get(index);
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCa() {
        return this.ca != null;
    }

    public boolean hasCertFile() {
        return this.certFile != null;
    }

    public boolean hasKeyFile() {
        return this.keyFile != null;
    }

    public boolean hasMatchingUrl(Predicate<String> predicate) {
        for (String item : this.urls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStoragePrefix() {
        return this.storagePrefix != null;
    }

    public boolean hasUrls() {
        return this.urls != null && !this.urls.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.ca, this.certFile, this.keyFile, this.storagePrefix, this.urls, this.additionalProperties);
    }

    public A removeAllFromUrls(Collection<String> items) {
        if (this.urls == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.urls.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromUrls(String ... items) {
        if (this.urls == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.urls.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToUrls(int index, String item) {
        if (this.urls == null) {
            this.urls = new ArrayList<String>();
        }
        this.urls.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ca != null) {
            sb.append("ca:");
            sb.append(this.ca);
            sb.append(",");
        }
        if (this.certFile != null) {
            sb.append("certFile:");
            sb.append(this.certFile);
            sb.append(",");
        }
        if (this.keyFile != null) {
            sb.append("keyFile:");
            sb.append(this.keyFile);
            sb.append(",");
        }
        if (this.storagePrefix != null) {
            sb.append("storagePrefix:");
            sb.append(this.storagePrefix);
            sb.append(",");
        }
        if (this.urls != null && !this.urls.isEmpty()) {
            sb.append("urls:");
            sb.append(this.urls);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCa(String ca) {
        this.ca = ca;
        return (A)((Object)this);
    }

    public A withCertFile(String certFile) {
        this.certFile = certFile;
        return (A)((Object)this);
    }

    public A withKeyFile(String keyFile) {
        this.keyFile = keyFile;
        return (A)((Object)this);
    }

    public A withStoragePrefix(String storagePrefix) {
        this.storagePrefix = storagePrefix;
        return (A)((Object)this);
    }

    public A withUrls(List<String> urls) {
        if (urls != null) {
            this.urls = new ArrayList<String>();
            for (String item : urls) {
                this.addToUrls(item);
            }
        } else {
            this.urls = null;
        }
        return (A)((Object)this);
    }

    public A withUrls(String ... urls) {
        if (this.urls != null) {
            this.urls.clear();
            this._visitables.remove((Object)"urls");
        }
        if (urls != null) {
            for (String item : urls) {
                this.addToUrls(item);
            }
        }
        return (A)((Object)this);
    }
}

