package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VSpherePlatformFailureDomainSpecFluent<A extends VSpherePlatformFailureDomainSpecFluent<A>> extends BaseFluent<A>{
  public VSpherePlatformFailureDomainSpecFluent() {
  }
  
  public VSpherePlatformFailureDomainSpecFluent(VSpherePlatformFailureDomainSpec instance) {
    this.copyInstance(instance);
  }
  private String name;
  private String region;
  private VSphereFailureDomainRegionAffinityBuilder regionAffinity;
  private String server;
  private VSpherePlatformTopologyBuilder topology;
  private String zone;
  private VSphereFailureDomainZoneAffinityBuilder zoneAffinity;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(VSpherePlatformFailureDomainSpec instance) {
    instance = (instance != null ? instance : new VSpherePlatformFailureDomainSpec());
    if (instance != null) {
          this.withName(instance.getName());
          this.withRegion(instance.getRegion());
          this.withRegionAffinity(instance.getRegionAffinity());
          this.withServer(instance.getServer());
          this.withTopology(instance.getTopology());
          this.withZone(instance.getZone());
          this.withZoneAffinity(instance.getZoneAffinity());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getRegion() {
    return this.region;
  }
  
  public A withRegion(String region) {
    this.region = region;
    return (A) this;
  }
  
  public boolean hasRegion() {
    return this.region != null;
  }
  
  public VSphereFailureDomainRegionAffinity buildRegionAffinity() {
    return this.regionAffinity != null ? this.regionAffinity.build() : null;
  }
  
  public A withRegionAffinity(VSphereFailureDomainRegionAffinity regionAffinity) {
    this._visitables.remove("regionAffinity");
    if (regionAffinity != null) {
        this.regionAffinity = new VSphereFailureDomainRegionAffinityBuilder(regionAffinity);
        this._visitables.get("regionAffinity").add(this.regionAffinity);
    } else {
        this.regionAffinity = null;
        this._visitables.get("regionAffinity").remove(this.regionAffinity);
    }
    return (A) this;
  }
  
  public boolean hasRegionAffinity() {
    return this.regionAffinity != null;
  }
  
  public A withNewRegionAffinity(String type) {
    return (A)withRegionAffinity(new VSphereFailureDomainRegionAffinity(type));
  }
  
  public RegionAffinityNested<A> withNewRegionAffinity() {
    return new RegionAffinityNested(null);
  }
  
  public RegionAffinityNested<A> withNewRegionAffinityLike(VSphereFailureDomainRegionAffinity item) {
    return new RegionAffinityNested(item);
  }
  
  public RegionAffinityNested<A> editRegionAffinity() {
    return withNewRegionAffinityLike(java.util.Optional.ofNullable(buildRegionAffinity()).orElse(null));
  }
  
  public RegionAffinityNested<A> editOrNewRegionAffinity() {
    return withNewRegionAffinityLike(java.util.Optional.ofNullable(buildRegionAffinity()).orElse(new VSphereFailureDomainRegionAffinityBuilder().build()));
  }
  
  public RegionAffinityNested<A> editOrNewRegionAffinityLike(VSphereFailureDomainRegionAffinity item) {
    return withNewRegionAffinityLike(java.util.Optional.ofNullable(buildRegionAffinity()).orElse(item));
  }
  
  public String getServer() {
    return this.server;
  }
  
  public A withServer(String server) {
    this.server = server;
    return (A) this;
  }
  
  public boolean hasServer() {
    return this.server != null;
  }
  
  public VSpherePlatformTopology buildTopology() {
    return this.topology != null ? this.topology.build() : null;
  }
  
  public A withTopology(VSpherePlatformTopology topology) {
    this._visitables.remove("topology");
    if (topology != null) {
        this.topology = new VSpherePlatformTopologyBuilder(topology);
        this._visitables.get("topology").add(this.topology);
    } else {
        this.topology = null;
        this._visitables.get("topology").remove(this.topology);
    }
    return (A) this;
  }
  
  public boolean hasTopology() {
    return this.topology != null;
  }
  
  public TopologyNested<A> withNewTopology() {
    return new TopologyNested(null);
  }
  
  public TopologyNested<A> withNewTopologyLike(VSpherePlatformTopology item) {
    return new TopologyNested(item);
  }
  
  public TopologyNested<A> editTopology() {
    return withNewTopologyLike(java.util.Optional.ofNullable(buildTopology()).orElse(null));
  }
  
  public TopologyNested<A> editOrNewTopology() {
    return withNewTopologyLike(java.util.Optional.ofNullable(buildTopology()).orElse(new VSpherePlatformTopologyBuilder().build()));
  }
  
  public TopologyNested<A> editOrNewTopologyLike(VSpherePlatformTopology item) {
    return withNewTopologyLike(java.util.Optional.ofNullable(buildTopology()).orElse(item));
  }
  
  public String getZone() {
    return this.zone;
  }
  
  public A withZone(String zone) {
    this.zone = zone;
    return (A) this;
  }
  
  public boolean hasZone() {
    return this.zone != null;
  }
  
  public VSphereFailureDomainZoneAffinity buildZoneAffinity() {
    return this.zoneAffinity != null ? this.zoneAffinity.build() : null;
  }
  
  public A withZoneAffinity(VSphereFailureDomainZoneAffinity zoneAffinity) {
    this._visitables.remove("zoneAffinity");
    if (zoneAffinity != null) {
        this.zoneAffinity = new VSphereFailureDomainZoneAffinityBuilder(zoneAffinity);
        this._visitables.get("zoneAffinity").add(this.zoneAffinity);
    } else {
        this.zoneAffinity = null;
        this._visitables.get("zoneAffinity").remove(this.zoneAffinity);
    }
    return (A) this;
  }
  
  public boolean hasZoneAffinity() {
    return this.zoneAffinity != null;
  }
  
  public ZoneAffinityNested<A> withNewZoneAffinity() {
    return new ZoneAffinityNested(null);
  }
  
  public ZoneAffinityNested<A> withNewZoneAffinityLike(VSphereFailureDomainZoneAffinity item) {
    return new ZoneAffinityNested(item);
  }
  
  public ZoneAffinityNested<A> editZoneAffinity() {
    return withNewZoneAffinityLike(java.util.Optional.ofNullable(buildZoneAffinity()).orElse(null));
  }
  
  public ZoneAffinityNested<A> editOrNewZoneAffinity() {
    return withNewZoneAffinityLike(java.util.Optional.ofNullable(buildZoneAffinity()).orElse(new VSphereFailureDomainZoneAffinityBuilder().build()));
  }
  
  public ZoneAffinityNested<A> editOrNewZoneAffinityLike(VSphereFailureDomainZoneAffinity item) {
    return withNewZoneAffinityLike(java.util.Optional.ofNullable(buildZoneAffinity()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VSpherePlatformFailureDomainSpecFluent that = (VSpherePlatformFailureDomainSpecFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(region, that.region)) return false;
    if (!java.util.Objects.equals(regionAffinity, that.regionAffinity)) return false;
    if (!java.util.Objects.equals(server, that.server)) return false;
    if (!java.util.Objects.equals(topology, that.topology)) return false;
    if (!java.util.Objects.equals(zone, that.zone)) return false;
    if (!java.util.Objects.equals(zoneAffinity, that.zoneAffinity)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  region,  regionAffinity,  server,  topology,  zone,  zoneAffinity,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (regionAffinity != null) { sb.append("regionAffinity:"); sb.append(regionAffinity + ","); }
    if (server != null) { sb.append("server:"); sb.append(server + ","); }
    if (topology != null) { sb.append("topology:"); sb.append(topology + ","); }
    if (zone != null) { sb.append("zone:"); sb.append(zone + ","); }
    if (zoneAffinity != null) { sb.append("zoneAffinity:"); sb.append(zoneAffinity + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RegionAffinityNested<N> extends VSphereFailureDomainRegionAffinityFluent<RegionAffinityNested<N>> implements Nested<N>{
    RegionAffinityNested(VSphereFailureDomainRegionAffinity item) {
      this.builder = new VSphereFailureDomainRegionAffinityBuilder(this, item);
    }
    VSphereFailureDomainRegionAffinityBuilder builder;
    
    public N and() {
      return (N) VSpherePlatformFailureDomainSpecFluent.this.withRegionAffinity(builder.build());
    }
    
    public N endRegionAffinity() {
      return and();
    }
    
  
  }
  public class TopologyNested<N> extends VSpherePlatformTopologyFluent<TopologyNested<N>> implements Nested<N>{
    TopologyNested(VSpherePlatformTopology item) {
      this.builder = new VSpherePlatformTopologyBuilder(this, item);
    }
    VSpherePlatformTopologyBuilder builder;
    
    public N and() {
      return (N) VSpherePlatformFailureDomainSpecFluent.this.withTopology(builder.build());
    }
    
    public N endTopology() {
      return and();
    }
    
  
  }
  public class ZoneAffinityNested<N> extends VSphereFailureDomainZoneAffinityFluent<ZoneAffinityNested<N>> implements Nested<N>{
    ZoneAffinityNested(VSphereFailureDomainZoneAffinity item) {
      this.builder = new VSphereFailureDomainZoneAffinityBuilder(this, item);
    }
    VSphereFailureDomainZoneAffinityBuilder builder;
    
    public N and() {
      return (N) VSpherePlatformFailureDomainSpecFluent.this.withZoneAffinity(builder.build());
    }
    
    public N endZoneAffinity() {
      return and();
    }
    
  
  }

}