package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VSphereFailureDomainZoneAffinityFluent<A extends VSphereFailureDomainZoneAffinityFluent<A>> extends BaseFluent<A>{
  public VSphereFailureDomainZoneAffinityFluent() {
  }
  
  public VSphereFailureDomainZoneAffinityFluent(VSphereFailureDomainZoneAffinity instance) {
    this.copyInstance(instance);
  }
  private VSphereFailureDomainHostGroupBuilder hostGroup;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(VSphereFailureDomainZoneAffinity instance) {
    instance = (instance != null ? instance : new VSphereFailureDomainZoneAffinity());
    if (instance != null) {
          this.withHostGroup(instance.getHostGroup());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public VSphereFailureDomainHostGroup buildHostGroup() {
    return this.hostGroup != null ? this.hostGroup.build() : null;
  }
  
  public A withHostGroup(VSphereFailureDomainHostGroup hostGroup) {
    this._visitables.remove("hostGroup");
    if (hostGroup != null) {
        this.hostGroup = new VSphereFailureDomainHostGroupBuilder(hostGroup);
        this._visitables.get("hostGroup").add(this.hostGroup);
    } else {
        this.hostGroup = null;
        this._visitables.get("hostGroup").remove(this.hostGroup);
    }
    return (A) this;
  }
  
  public boolean hasHostGroup() {
    return this.hostGroup != null;
  }
  
  public A withNewHostGroup(String hostGroup,String vmGroup,String vmHostRule) {
    return (A)withHostGroup(new VSphereFailureDomainHostGroup(hostGroup, vmGroup, vmHostRule));
  }
  
  public HostGroupNested<A> withNewHostGroup() {
    return new HostGroupNested(null);
  }
  
  public HostGroupNested<A> withNewHostGroupLike(VSphereFailureDomainHostGroup item) {
    return new HostGroupNested(item);
  }
  
  public HostGroupNested<A> editHostGroup() {
    return withNewHostGroupLike(java.util.Optional.ofNullable(buildHostGroup()).orElse(null));
  }
  
  public HostGroupNested<A> editOrNewHostGroup() {
    return withNewHostGroupLike(java.util.Optional.ofNullable(buildHostGroup()).orElse(new VSphereFailureDomainHostGroupBuilder().build()));
  }
  
  public HostGroupNested<A> editOrNewHostGroupLike(VSphereFailureDomainHostGroup item) {
    return withNewHostGroupLike(java.util.Optional.ofNullable(buildHostGroup()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VSphereFailureDomainZoneAffinityFluent that = (VSphereFailureDomainZoneAffinityFluent) o;
    if (!java.util.Objects.equals(hostGroup, that.hostGroup)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(hostGroup,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hostGroup != null) { sb.append("hostGroup:"); sb.append(hostGroup + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class HostGroupNested<N> extends VSphereFailureDomainHostGroupFluent<HostGroupNested<N>> implements Nested<N>{
    HostGroupNested(VSphereFailureDomainHostGroup item) {
      this.builder = new VSphereFailureDomainHostGroupBuilder(this, item);
    }
    VSphereFailureDomainHostGroupBuilder builder;
    
    public N and() {
      return (N) VSphereFailureDomainZoneAffinityFluent.this.withHostGroup(builder.build());
    }
    
    public N endHostGroup() {
      return and();
    }
    
  
  }

}