package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class UsernamePrefixBuilder extends UsernamePrefixFluent<UsernamePrefixBuilder> implements VisitableBuilder<UsernamePrefix,UsernamePrefixBuilder>{
  public UsernamePrefixBuilder() {
    this(new UsernamePrefix());
  }
  
  public UsernamePrefixBuilder(UsernamePrefixFluent<?> fluent) {
    this(fluent, new UsernamePrefix());
  }
  
  public UsernamePrefixBuilder(UsernamePrefixFluent<?> fluent,UsernamePrefix instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public UsernamePrefixBuilder(UsernamePrefix instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  UsernamePrefixFluent<?> fluent;
  
  public UsernamePrefix build() {
    UsernamePrefix buildable = new UsernamePrefix(fluent.getPrefixString());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}