package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RemoteConnectionInfoBuilder extends RemoteConnectionInfoFluent<RemoteConnectionInfoBuilder> implements VisitableBuilder<RemoteConnectionInfo,RemoteConnectionInfoBuilder>{
  public RemoteConnectionInfoBuilder() {
    this(new RemoteConnectionInfo());
  }
  
  public RemoteConnectionInfoBuilder(RemoteConnectionInfoFluent<?> fluent) {
    this(fluent, new RemoteConnectionInfo());
  }
  
  public RemoteConnectionInfoBuilder(RemoteConnectionInfoFluent<?> fluent,RemoteConnectionInfo instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RemoteConnectionInfoBuilder(RemoteConnectionInfo instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RemoteConnectionInfoFluent<?> fluent;
  
  public RemoteConnectionInfo build() {
    RemoteConnectionInfo buildable = new RemoteConnectionInfo(fluent.getCa(),fluent.getCertFile(),fluent.getKeyFile(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}