package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OpenStackPlatformStatusBuilder extends OpenStackPlatformStatusFluent<OpenStackPlatformStatusBuilder> implements VisitableBuilder<OpenStackPlatformStatus,OpenStackPlatformStatusBuilder>{
  public OpenStackPlatformStatusBuilder() {
    this(new OpenStackPlatformStatus());
  }
  
  public OpenStackPlatformStatusBuilder(OpenStackPlatformStatusFluent<?> fluent) {
    this(fluent, new OpenStackPlatformStatus());
  }
  
  public OpenStackPlatformStatusBuilder(OpenStackPlatformStatusFluent<?> fluent,OpenStackPlatformStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OpenStackPlatformStatusBuilder(OpenStackPlatformStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OpenStackPlatformStatusFluent<?> fluent;
  
  public OpenStackPlatformStatus build() {
    OpenStackPlatformStatus buildable = new OpenStackPlatformStatus(fluent.getApiServerInternalIP(),fluent.getApiServerInternalIPs(),fluent.getCloudName(),fluent.getIngressIP(),fluent.getIngressIPs(),fluent.buildLoadBalancer(),fluent.getMachineNetworks(),fluent.getNodeDNSIP());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}