package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OIDCClientConfigFluent<A extends OIDCClientConfigFluent<A>> extends BaseFluent<A>{
  public OIDCClientConfigFluent() {
  }
  
  public OIDCClientConfigFluent(OIDCClientConfig instance) {
    this.copyInstance(instance);
  }
  private String clientID;
  private SecretNameReferenceBuilder clientSecret;
  private String componentName;
  private String componentNamespace;
  private List<String> extraScopes = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OIDCClientConfig instance) {
    instance = (instance != null ? instance : new OIDCClientConfig());
    if (instance != null) {
          this.withClientID(instance.getClientID());
          this.withClientSecret(instance.getClientSecret());
          this.withComponentName(instance.getComponentName());
          this.withComponentNamespace(instance.getComponentNamespace());
          this.withExtraScopes(instance.getExtraScopes());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getClientID() {
    return this.clientID;
  }
  
  public A withClientID(String clientID) {
    this.clientID = clientID;
    return (A) this;
  }
  
  public boolean hasClientID() {
    return this.clientID != null;
  }
  
  public SecretNameReference buildClientSecret() {
    return this.clientSecret != null ? this.clientSecret.build() : null;
  }
  
  public A withClientSecret(SecretNameReference clientSecret) {
    this._visitables.remove("clientSecret");
    if (clientSecret != null) {
        this.clientSecret = new SecretNameReferenceBuilder(clientSecret);
        this._visitables.get("clientSecret").add(this.clientSecret);
    } else {
        this.clientSecret = null;
        this._visitables.get("clientSecret").remove(this.clientSecret);
    }
    return (A) this;
  }
  
  public boolean hasClientSecret() {
    return this.clientSecret != null;
  }
  
  public A withNewClientSecret(String name) {
    return (A)withClientSecret(new SecretNameReference(name));
  }
  
  public ClientSecretNested<A> withNewClientSecret() {
    return new ClientSecretNested(null);
  }
  
  public ClientSecretNested<A> withNewClientSecretLike(SecretNameReference item) {
    return new ClientSecretNested(item);
  }
  
  public ClientSecretNested<A> editClientSecret() {
    return withNewClientSecretLike(java.util.Optional.ofNullable(buildClientSecret()).orElse(null));
  }
  
  public ClientSecretNested<A> editOrNewClientSecret() {
    return withNewClientSecretLike(java.util.Optional.ofNullable(buildClientSecret()).orElse(new SecretNameReferenceBuilder().build()));
  }
  
  public ClientSecretNested<A> editOrNewClientSecretLike(SecretNameReference item) {
    return withNewClientSecretLike(java.util.Optional.ofNullable(buildClientSecret()).orElse(item));
  }
  
  public String getComponentName() {
    return this.componentName;
  }
  
  public A withComponentName(String componentName) {
    this.componentName = componentName;
    return (A) this;
  }
  
  public boolean hasComponentName() {
    return this.componentName != null;
  }
  
  public String getComponentNamespace() {
    return this.componentNamespace;
  }
  
  public A withComponentNamespace(String componentNamespace) {
    this.componentNamespace = componentNamespace;
    return (A) this;
  }
  
  public boolean hasComponentNamespace() {
    return this.componentNamespace != null;
  }
  
  public A addToExtraScopes(int index,String item) {
    if (this.extraScopes == null) {this.extraScopes = new ArrayList<String>();}
    this.extraScopes.add(index, item);
    return (A)this;
  }
  
  public A setToExtraScopes(int index,String item) {
    if (this.extraScopes == null) {this.extraScopes = new ArrayList<String>();}
    this.extraScopes.set(index, item); return (A)this;
  }
  
  public A addToExtraScopes(java.lang.String... items) {
    if (this.extraScopes == null) {this.extraScopes = new ArrayList<String>();}
    for (String item : items) {this.extraScopes.add(item);} return (A)this;
  }
  
  public A addAllToExtraScopes(Collection<String> items) {
    if (this.extraScopes == null) {this.extraScopes = new ArrayList<String>();}
    for (String item : items) {this.extraScopes.add(item);} return (A)this;
  }
  
  public A removeFromExtraScopes(java.lang.String... items) {
    if (this.extraScopes == null) return (A)this;
    for (String item : items) { this.extraScopes.remove(item);} return (A)this;
  }
  
  public A removeAllFromExtraScopes(Collection<String> items) {
    if (this.extraScopes == null) return (A)this;
    for (String item : items) { this.extraScopes.remove(item);} return (A)this;
  }
  
  public List<String> getExtraScopes() {
    return this.extraScopes;
  }
  
  public String getExtraScope(int index) {
    return this.extraScopes.get(index);
  }
  
  public String getFirstExtraScope() {
    return this.extraScopes.get(0);
  }
  
  public String getLastExtraScope() {
    return this.extraScopes.get(extraScopes.size() - 1);
  }
  
  public String getMatchingExtraScope(Predicate<String> predicate) {
      for (String item : extraScopes) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingExtraScope(Predicate<String> predicate) {
      for (String item : extraScopes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withExtraScopes(List<String> extraScopes) {
    if (extraScopes != null) {
        this.extraScopes = new ArrayList();
        for (String item : extraScopes) {
          this.addToExtraScopes(item);
        }
    } else {
      this.extraScopes = null;
    }
    return (A) this;
  }
  
  public A withExtraScopes(java.lang.String... extraScopes) {
    if (this.extraScopes != null) {
        this.extraScopes.clear();
        _visitables.remove("extraScopes");
    }
    if (extraScopes != null) {
      for (String item : extraScopes) {
        this.addToExtraScopes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasExtraScopes() {
    return this.extraScopes != null && !this.extraScopes.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OIDCClientConfigFluent that = (OIDCClientConfigFluent) o;
    if (!java.util.Objects.equals(clientID, that.clientID)) return false;
    if (!java.util.Objects.equals(clientSecret, that.clientSecret)) return false;
    if (!java.util.Objects.equals(componentName, that.componentName)) return false;
    if (!java.util.Objects.equals(componentNamespace, that.componentNamespace)) return false;
    if (!java.util.Objects.equals(extraScopes, that.extraScopes)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clientID,  clientSecret,  componentName,  componentNamespace,  extraScopes,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientID != null) { sb.append("clientID:"); sb.append(clientID + ","); }
    if (clientSecret != null) { sb.append("clientSecret:"); sb.append(clientSecret + ","); }
    if (componentName != null) { sb.append("componentName:"); sb.append(componentName + ","); }
    if (componentNamespace != null) { sb.append("componentNamespace:"); sb.append(componentNamespace + ","); }
    if (extraScopes != null && !extraScopes.isEmpty()) { sb.append("extraScopes:"); sb.append(extraScopes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClientSecretNested<N> extends SecretNameReferenceFluent<ClientSecretNested<N>> implements Nested<N>{
    ClientSecretNested(SecretNameReference item) {
      this.builder = new SecretNameReferenceBuilder(this, item);
    }
    SecretNameReferenceBuilder builder;
    
    public N and() {
      return (N) OIDCClientConfigFluent.this.withClientSecret(builder.build());
    }
    
    public N endClientSecret() {
      return and();
    }
    
  
  }

}