package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NetworkDiagnosticsFluent<A extends NetworkDiagnosticsFluent<A>> extends BaseFluent<A>{
  public NetworkDiagnosticsFluent() {
  }
  
  public NetworkDiagnosticsFluent(NetworkDiagnostics instance) {
    this.copyInstance(instance);
  }
  private String mode;
  private NetworkDiagnosticsSourcePlacementBuilder sourcePlacement;
  private NetworkDiagnosticsTargetPlacementBuilder targetPlacement;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NetworkDiagnostics instance) {
    instance = (instance != null ? instance : new NetworkDiagnostics());
    if (instance != null) {
          this.withMode(instance.getMode());
          this.withSourcePlacement(instance.getSourcePlacement());
          this.withTargetPlacement(instance.getTargetPlacement());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getMode() {
    return this.mode;
  }
  
  public A withMode(String mode) {
    this.mode = mode;
    return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public NetworkDiagnosticsSourcePlacement buildSourcePlacement() {
    return this.sourcePlacement != null ? this.sourcePlacement.build() : null;
  }
  
  public A withSourcePlacement(NetworkDiagnosticsSourcePlacement sourcePlacement) {
    this._visitables.remove("sourcePlacement");
    if (sourcePlacement != null) {
        this.sourcePlacement = new NetworkDiagnosticsSourcePlacementBuilder(sourcePlacement);
        this._visitables.get("sourcePlacement").add(this.sourcePlacement);
    } else {
        this.sourcePlacement = null;
        this._visitables.get("sourcePlacement").remove(this.sourcePlacement);
    }
    return (A) this;
  }
  
  public boolean hasSourcePlacement() {
    return this.sourcePlacement != null;
  }
  
  public SourcePlacementNested<A> withNewSourcePlacement() {
    return new SourcePlacementNested(null);
  }
  
  public SourcePlacementNested<A> withNewSourcePlacementLike(NetworkDiagnosticsSourcePlacement item) {
    return new SourcePlacementNested(item);
  }
  
  public SourcePlacementNested<A> editSourcePlacement() {
    return withNewSourcePlacementLike(java.util.Optional.ofNullable(buildSourcePlacement()).orElse(null));
  }
  
  public SourcePlacementNested<A> editOrNewSourcePlacement() {
    return withNewSourcePlacementLike(java.util.Optional.ofNullable(buildSourcePlacement()).orElse(new NetworkDiagnosticsSourcePlacementBuilder().build()));
  }
  
  public SourcePlacementNested<A> editOrNewSourcePlacementLike(NetworkDiagnosticsSourcePlacement item) {
    return withNewSourcePlacementLike(java.util.Optional.ofNullable(buildSourcePlacement()).orElse(item));
  }
  
  public NetworkDiagnosticsTargetPlacement buildTargetPlacement() {
    return this.targetPlacement != null ? this.targetPlacement.build() : null;
  }
  
  public A withTargetPlacement(NetworkDiagnosticsTargetPlacement targetPlacement) {
    this._visitables.remove("targetPlacement");
    if (targetPlacement != null) {
        this.targetPlacement = new NetworkDiagnosticsTargetPlacementBuilder(targetPlacement);
        this._visitables.get("targetPlacement").add(this.targetPlacement);
    } else {
        this.targetPlacement = null;
        this._visitables.get("targetPlacement").remove(this.targetPlacement);
    }
    return (A) this;
  }
  
  public boolean hasTargetPlacement() {
    return this.targetPlacement != null;
  }
  
  public TargetPlacementNested<A> withNewTargetPlacement() {
    return new TargetPlacementNested(null);
  }
  
  public TargetPlacementNested<A> withNewTargetPlacementLike(NetworkDiagnosticsTargetPlacement item) {
    return new TargetPlacementNested(item);
  }
  
  public TargetPlacementNested<A> editTargetPlacement() {
    return withNewTargetPlacementLike(java.util.Optional.ofNullable(buildTargetPlacement()).orElse(null));
  }
  
  public TargetPlacementNested<A> editOrNewTargetPlacement() {
    return withNewTargetPlacementLike(java.util.Optional.ofNullable(buildTargetPlacement()).orElse(new NetworkDiagnosticsTargetPlacementBuilder().build()));
  }
  
  public TargetPlacementNested<A> editOrNewTargetPlacementLike(NetworkDiagnosticsTargetPlacement item) {
    return withNewTargetPlacementLike(java.util.Optional.ofNullable(buildTargetPlacement()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkDiagnosticsFluent that = (NetworkDiagnosticsFluent) o;
    if (!java.util.Objects.equals(mode, that.mode)) return false;
    if (!java.util.Objects.equals(sourcePlacement, that.sourcePlacement)) return false;
    if (!java.util.Objects.equals(targetPlacement, that.targetPlacement)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(mode,  sourcePlacement,  targetPlacement,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (sourcePlacement != null) { sb.append("sourcePlacement:"); sb.append(sourcePlacement + ","); }
    if (targetPlacement != null) { sb.append("targetPlacement:"); sb.append(targetPlacement + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SourcePlacementNested<N> extends NetworkDiagnosticsSourcePlacementFluent<SourcePlacementNested<N>> implements Nested<N>{
    SourcePlacementNested(NetworkDiagnosticsSourcePlacement item) {
      this.builder = new NetworkDiagnosticsSourcePlacementBuilder(this, item);
    }
    NetworkDiagnosticsSourcePlacementBuilder builder;
    
    public N and() {
      return (N) NetworkDiagnosticsFluent.this.withSourcePlacement(builder.build());
    }
    
    public N endSourcePlacement() {
      return and();
    }
    
  
  }
  public class TargetPlacementNested<N> extends NetworkDiagnosticsTargetPlacementFluent<TargetPlacementNested<N>> implements Nested<N>{
    TargetPlacementNested(NetworkDiagnosticsTargetPlacement item) {
      this.builder = new NetworkDiagnosticsTargetPlacementBuilder(this, item);
    }
    NetworkDiagnosticsTargetPlacementBuilder builder;
    
    public N and() {
      return (N) NetworkDiagnosticsFluent.this.withTargetPlacement(builder.build());
    }
    
    public N endTargetPlacement() {
      return and();
    }
    
  
  }

}