package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterVersionSpecFluent<A extends ClusterVersionSpecFluent<A>> extends BaseFluent<A>{
  public ClusterVersionSpecFluent() {
  }
  
  public ClusterVersionSpecFluent(ClusterVersionSpec instance) {
    this.copyInstance(instance);
  }
  private ClusterVersionCapabilitiesSpecBuilder capabilities;
  private String channel;
  private String clusterID;
  private UpdateBuilder desiredUpdate;
  private ArrayList<ComponentOverrideBuilder> overrides = new ArrayList<ComponentOverrideBuilder>();
  private ArrayList<SignatureStoreBuilder> signatureStores = new ArrayList<SignatureStoreBuilder>();
  private String upstream;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterVersionSpec instance) {
    instance = (instance != null ? instance : new ClusterVersionSpec());
    if (instance != null) {
          this.withCapabilities(instance.getCapabilities());
          this.withChannel(instance.getChannel());
          this.withClusterID(instance.getClusterID());
          this.withDesiredUpdate(instance.getDesiredUpdate());
          this.withOverrides(instance.getOverrides());
          this.withSignatureStores(instance.getSignatureStores());
          this.withUpstream(instance.getUpstream());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ClusterVersionCapabilitiesSpec buildCapabilities() {
    return this.capabilities != null ? this.capabilities.build() : null;
  }
  
  public A withCapabilities(ClusterVersionCapabilitiesSpec capabilities) {
    this._visitables.remove("capabilities");
    if (capabilities != null) {
        this.capabilities = new ClusterVersionCapabilitiesSpecBuilder(capabilities);
        this._visitables.get("capabilities").add(this.capabilities);
    } else {
        this.capabilities = null;
        this._visitables.get("capabilities").remove(this.capabilities);
    }
    return (A) this;
  }
  
  public boolean hasCapabilities() {
    return this.capabilities != null;
  }
  
  public CapabilitiesNested<A> withNewCapabilities() {
    return new CapabilitiesNested(null);
  }
  
  public CapabilitiesNested<A> withNewCapabilitiesLike(ClusterVersionCapabilitiesSpec item) {
    return new CapabilitiesNested(item);
  }
  
  public CapabilitiesNested<A> editCapabilities() {
    return withNewCapabilitiesLike(java.util.Optional.ofNullable(buildCapabilities()).orElse(null));
  }
  
  public CapabilitiesNested<A> editOrNewCapabilities() {
    return withNewCapabilitiesLike(java.util.Optional.ofNullable(buildCapabilities()).orElse(new ClusterVersionCapabilitiesSpecBuilder().build()));
  }
  
  public CapabilitiesNested<A> editOrNewCapabilitiesLike(ClusterVersionCapabilitiesSpec item) {
    return withNewCapabilitiesLike(java.util.Optional.ofNullable(buildCapabilities()).orElse(item));
  }
  
  public String getChannel() {
    return this.channel;
  }
  
  public A withChannel(String channel) {
    this.channel = channel;
    return (A) this;
  }
  
  public boolean hasChannel() {
    return this.channel != null;
  }
  
  public String getClusterID() {
    return this.clusterID;
  }
  
  public A withClusterID(String clusterID) {
    this.clusterID = clusterID;
    return (A) this;
  }
  
  public boolean hasClusterID() {
    return this.clusterID != null;
  }
  
  public Update buildDesiredUpdate() {
    return this.desiredUpdate != null ? this.desiredUpdate.build() : null;
  }
  
  public A withDesiredUpdate(Update desiredUpdate) {
    this._visitables.remove("desiredUpdate");
    if (desiredUpdate != null) {
        this.desiredUpdate = new UpdateBuilder(desiredUpdate);
        this._visitables.get("desiredUpdate").add(this.desiredUpdate);
    } else {
        this.desiredUpdate = null;
        this._visitables.get("desiredUpdate").remove(this.desiredUpdate);
    }
    return (A) this;
  }
  
  public boolean hasDesiredUpdate() {
    return this.desiredUpdate != null;
  }
  
  public A withNewDesiredUpdate(String architecture,Boolean force,String image,String version) {
    return (A)withDesiredUpdate(new Update(architecture, force, image, version));
  }
  
  public DesiredUpdateNested<A> withNewDesiredUpdate() {
    return new DesiredUpdateNested(null);
  }
  
  public DesiredUpdateNested<A> withNewDesiredUpdateLike(Update item) {
    return new DesiredUpdateNested(item);
  }
  
  public DesiredUpdateNested<A> editDesiredUpdate() {
    return withNewDesiredUpdateLike(java.util.Optional.ofNullable(buildDesiredUpdate()).orElse(null));
  }
  
  public DesiredUpdateNested<A> editOrNewDesiredUpdate() {
    return withNewDesiredUpdateLike(java.util.Optional.ofNullable(buildDesiredUpdate()).orElse(new UpdateBuilder().build()));
  }
  
  public DesiredUpdateNested<A> editOrNewDesiredUpdateLike(Update item) {
    return withNewDesiredUpdateLike(java.util.Optional.ofNullable(buildDesiredUpdate()).orElse(item));
  }
  
  public A addToOverrides(int index,ComponentOverride item) {
    if (this.overrides == null) {this.overrides = new ArrayList<ComponentOverrideBuilder>();}
    ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);
    if (index < 0 || index >= overrides.size()) {
        _visitables.get("overrides").add(builder);
        overrides.add(builder);
    } else {
        _visitables.get("overrides").add(builder);
        overrides.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToOverrides(int index,ComponentOverride item) {
    if (this.overrides == null) {this.overrides = new ArrayList<ComponentOverrideBuilder>();}
    ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);
    if (index < 0 || index >= overrides.size()) {
        _visitables.get("overrides").add(builder);
        overrides.add(builder);
    } else {
        _visitables.get("overrides").add(builder);
        overrides.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToOverrides(io.fabric8.openshift.api.model.config.v1.ComponentOverride... items) {
    if (this.overrides == null) {this.overrides = new ArrayList<ComponentOverrideBuilder>();}
    for (ComponentOverride item : items) {ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);_visitables.get("overrides").add(builder);this.overrides.add(builder);} return (A)this;
  }
  
  public A addAllToOverrides(Collection<ComponentOverride> items) {
    if (this.overrides == null) {this.overrides = new ArrayList<ComponentOverrideBuilder>();}
    for (ComponentOverride item : items) {ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);_visitables.get("overrides").add(builder);this.overrides.add(builder);} return (A)this;
  }
  
  public A removeFromOverrides(io.fabric8.openshift.api.model.config.v1.ComponentOverride... items) {
    if (this.overrides == null) return (A)this;
    for (ComponentOverride item : items) {ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);_visitables.get("overrides").remove(builder); this.overrides.remove(builder);} return (A)this;
  }
  
  public A removeAllFromOverrides(Collection<ComponentOverride> items) {
    if (this.overrides == null) return (A)this;
    for (ComponentOverride item : items) {ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);_visitables.get("overrides").remove(builder); this.overrides.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromOverrides(Predicate<ComponentOverrideBuilder> predicate) {
    if (overrides == null) return (A) this;
    final Iterator<ComponentOverrideBuilder> each = overrides.iterator();
    final List visitables = _visitables.get("overrides");
    while (each.hasNext()) {
      ComponentOverrideBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ComponentOverride> buildOverrides() {
    return this.overrides != null ? build(overrides) : null;
  }
  
  public ComponentOverride buildOverride(int index) {
    return this.overrides.get(index).build();
  }
  
  public ComponentOverride buildFirstOverride() {
    return this.overrides.get(0).build();
  }
  
  public ComponentOverride buildLastOverride() {
    return this.overrides.get(overrides.size() - 1).build();
  }
  
  public ComponentOverride buildMatchingOverride(Predicate<ComponentOverrideBuilder> predicate) {
      for (ComponentOverrideBuilder item : overrides) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingOverride(Predicate<ComponentOverrideBuilder> predicate) {
      for (ComponentOverrideBuilder item : overrides) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withOverrides(List<ComponentOverride> overrides) {
    if (this.overrides != null) {
      this._visitables.get("overrides").clear();
    }
    if (overrides != null) {
        this.overrides = new ArrayList();
        for (ComponentOverride item : overrides) {
          this.addToOverrides(item);
        }
    } else {
      this.overrides = null;
    }
    return (A) this;
  }
  
  public A withOverrides(io.fabric8.openshift.api.model.config.v1.ComponentOverride... overrides) {
    if (this.overrides != null) {
        this.overrides.clear();
        _visitables.remove("overrides");
    }
    if (overrides != null) {
      for (ComponentOverride item : overrides) {
        this.addToOverrides(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasOverrides() {
    return this.overrides != null && !this.overrides.isEmpty();
  }
  
  public A addNewOverride(String group,String kind,String name,String namespace,Boolean unmanaged) {
    return (A)addToOverrides(new ComponentOverride(group, kind, name, namespace, unmanaged));
  }
  
  public OverridesNested<A> addNewOverride() {
    return new OverridesNested(-1, null);
  }
  
  public OverridesNested<A> addNewOverrideLike(ComponentOverride item) {
    return new OverridesNested(-1, item);
  }
  
  public OverridesNested<A> setNewOverrideLike(int index,ComponentOverride item) {
    return new OverridesNested(index, item);
  }
  
  public OverridesNested<A> editOverride(int index) {
    if (overrides.size() <= index) throw new RuntimeException("Can't edit overrides. Index exceeds size.");
    return setNewOverrideLike(index, buildOverride(index));
  }
  
  public OverridesNested<A> editFirstOverride() {
    if (overrides.size() == 0) throw new RuntimeException("Can't edit first overrides. The list is empty.");
    return setNewOverrideLike(0, buildOverride(0));
  }
  
  public OverridesNested<A> editLastOverride() {
    int index = overrides.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last overrides. The list is empty.");
    return setNewOverrideLike(index, buildOverride(index));
  }
  
  public OverridesNested<A> editMatchingOverride(Predicate<ComponentOverrideBuilder> predicate) {
    int index = -1;
    for (int i=0;i<overrides.size();i++) { 
    if (predicate.test(overrides.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching overrides. No match found.");
    return setNewOverrideLike(index, buildOverride(index));
  }
  
  public A addToSignatureStores(int index,SignatureStore item) {
    if (this.signatureStores == null) {this.signatureStores = new ArrayList<SignatureStoreBuilder>();}
    SignatureStoreBuilder builder = new SignatureStoreBuilder(item);
    if (index < 0 || index >= signatureStores.size()) {
        _visitables.get("signatureStores").add(builder);
        signatureStores.add(builder);
    } else {
        _visitables.get("signatureStores").add(builder);
        signatureStores.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToSignatureStores(int index,SignatureStore item) {
    if (this.signatureStores == null) {this.signatureStores = new ArrayList<SignatureStoreBuilder>();}
    SignatureStoreBuilder builder = new SignatureStoreBuilder(item);
    if (index < 0 || index >= signatureStores.size()) {
        _visitables.get("signatureStores").add(builder);
        signatureStores.add(builder);
    } else {
        _visitables.get("signatureStores").add(builder);
        signatureStores.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToSignatureStores(io.fabric8.openshift.api.model.config.v1.SignatureStore... items) {
    if (this.signatureStores == null) {this.signatureStores = new ArrayList<SignatureStoreBuilder>();}
    for (SignatureStore item : items) {SignatureStoreBuilder builder = new SignatureStoreBuilder(item);_visitables.get("signatureStores").add(builder);this.signatureStores.add(builder);} return (A)this;
  }
  
  public A addAllToSignatureStores(Collection<SignatureStore> items) {
    if (this.signatureStores == null) {this.signatureStores = new ArrayList<SignatureStoreBuilder>();}
    for (SignatureStore item : items) {SignatureStoreBuilder builder = new SignatureStoreBuilder(item);_visitables.get("signatureStores").add(builder);this.signatureStores.add(builder);} return (A)this;
  }
  
  public A removeFromSignatureStores(io.fabric8.openshift.api.model.config.v1.SignatureStore... items) {
    if (this.signatureStores == null) return (A)this;
    for (SignatureStore item : items) {SignatureStoreBuilder builder = new SignatureStoreBuilder(item);_visitables.get("signatureStores").remove(builder); this.signatureStores.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSignatureStores(Collection<SignatureStore> items) {
    if (this.signatureStores == null) return (A)this;
    for (SignatureStore item : items) {SignatureStoreBuilder builder = new SignatureStoreBuilder(item);_visitables.get("signatureStores").remove(builder); this.signatureStores.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSignatureStores(Predicate<SignatureStoreBuilder> predicate) {
    if (signatureStores == null) return (A) this;
    final Iterator<SignatureStoreBuilder> each = signatureStores.iterator();
    final List visitables = _visitables.get("signatureStores");
    while (each.hasNext()) {
      SignatureStoreBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SignatureStore> buildSignatureStores() {
    return this.signatureStores != null ? build(signatureStores) : null;
  }
  
  public SignatureStore buildSignatureStore(int index) {
    return this.signatureStores.get(index).build();
  }
  
  public SignatureStore buildFirstSignatureStore() {
    return this.signatureStores.get(0).build();
  }
  
  public SignatureStore buildLastSignatureStore() {
    return this.signatureStores.get(signatureStores.size() - 1).build();
  }
  
  public SignatureStore buildMatchingSignatureStore(Predicate<SignatureStoreBuilder> predicate) {
      for (SignatureStoreBuilder item : signatureStores) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSignatureStore(Predicate<SignatureStoreBuilder> predicate) {
      for (SignatureStoreBuilder item : signatureStores) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSignatureStores(List<SignatureStore> signatureStores) {
    if (this.signatureStores != null) {
      this._visitables.get("signatureStores").clear();
    }
    if (signatureStores != null) {
        this.signatureStores = new ArrayList();
        for (SignatureStore item : signatureStores) {
          this.addToSignatureStores(item);
        }
    } else {
      this.signatureStores = null;
    }
    return (A) this;
  }
  
  public A withSignatureStores(io.fabric8.openshift.api.model.config.v1.SignatureStore... signatureStores) {
    if (this.signatureStores != null) {
        this.signatureStores.clear();
        _visitables.remove("signatureStores");
    }
    if (signatureStores != null) {
      for (SignatureStore item : signatureStores) {
        this.addToSignatureStores(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSignatureStores() {
    return this.signatureStores != null && !this.signatureStores.isEmpty();
  }
  
  public SignatureStoresNested<A> addNewSignatureStore() {
    return new SignatureStoresNested(-1, null);
  }
  
  public SignatureStoresNested<A> addNewSignatureStoreLike(SignatureStore item) {
    return new SignatureStoresNested(-1, item);
  }
  
  public SignatureStoresNested<A> setNewSignatureStoreLike(int index,SignatureStore item) {
    return new SignatureStoresNested(index, item);
  }
  
  public SignatureStoresNested<A> editSignatureStore(int index) {
    if (signatureStores.size() <= index) throw new RuntimeException("Can't edit signatureStores. Index exceeds size.");
    return setNewSignatureStoreLike(index, buildSignatureStore(index));
  }
  
  public SignatureStoresNested<A> editFirstSignatureStore() {
    if (signatureStores.size() == 0) throw new RuntimeException("Can't edit first signatureStores. The list is empty.");
    return setNewSignatureStoreLike(0, buildSignatureStore(0));
  }
  
  public SignatureStoresNested<A> editLastSignatureStore() {
    int index = signatureStores.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last signatureStores. The list is empty.");
    return setNewSignatureStoreLike(index, buildSignatureStore(index));
  }
  
  public SignatureStoresNested<A> editMatchingSignatureStore(Predicate<SignatureStoreBuilder> predicate) {
    int index = -1;
    for (int i=0;i<signatureStores.size();i++) { 
    if (predicate.test(signatureStores.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching signatureStores. No match found.");
    return setNewSignatureStoreLike(index, buildSignatureStore(index));
  }
  
  public String getUpstream() {
    return this.upstream;
  }
  
  public A withUpstream(String upstream) {
    this.upstream = upstream;
    return (A) this;
  }
  
  public boolean hasUpstream() {
    return this.upstream != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterVersionSpecFluent that = (ClusterVersionSpecFluent) o;
    if (!java.util.Objects.equals(capabilities, that.capabilities)) return false;
    if (!java.util.Objects.equals(channel, that.channel)) return false;
    if (!java.util.Objects.equals(clusterID, that.clusterID)) return false;
    if (!java.util.Objects.equals(desiredUpdate, that.desiredUpdate)) return false;
    if (!java.util.Objects.equals(overrides, that.overrides)) return false;
    if (!java.util.Objects.equals(signatureStores, that.signatureStores)) return false;
    if (!java.util.Objects.equals(upstream, that.upstream)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(capabilities,  channel,  clusterID,  desiredUpdate,  overrides,  signatureStores,  upstream,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (capabilities != null) { sb.append("capabilities:"); sb.append(capabilities + ","); }
    if (channel != null) { sb.append("channel:"); sb.append(channel + ","); }
    if (clusterID != null) { sb.append("clusterID:"); sb.append(clusterID + ","); }
    if (desiredUpdate != null) { sb.append("desiredUpdate:"); sb.append(desiredUpdate + ","); }
    if (overrides != null && !overrides.isEmpty()) { sb.append("overrides:"); sb.append(overrides + ","); }
    if (signatureStores != null && !signatureStores.isEmpty()) { sb.append("signatureStores:"); sb.append(signatureStores + ","); }
    if (upstream != null) { sb.append("upstream:"); sb.append(upstream + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CapabilitiesNested<N> extends ClusterVersionCapabilitiesSpecFluent<CapabilitiesNested<N>> implements Nested<N>{
    CapabilitiesNested(ClusterVersionCapabilitiesSpec item) {
      this.builder = new ClusterVersionCapabilitiesSpecBuilder(this, item);
    }
    ClusterVersionCapabilitiesSpecBuilder builder;
    
    public N and() {
      return (N) ClusterVersionSpecFluent.this.withCapabilities(builder.build());
    }
    
    public N endCapabilities() {
      return and();
    }
    
  
  }
  public class DesiredUpdateNested<N> extends UpdateFluent<DesiredUpdateNested<N>> implements Nested<N>{
    DesiredUpdateNested(Update item) {
      this.builder = new UpdateBuilder(this, item);
    }
    UpdateBuilder builder;
    
    public N and() {
      return (N) ClusterVersionSpecFluent.this.withDesiredUpdate(builder.build());
    }
    
    public N endDesiredUpdate() {
      return and();
    }
    
  
  }
  public class OverridesNested<N> extends ComponentOverrideFluent<OverridesNested<N>> implements Nested<N>{
    OverridesNested(int index,ComponentOverride item) {
      this.index = index;
      this.builder = new ComponentOverrideBuilder(this, item);
    }
    ComponentOverrideBuilder builder;
    int index;
    
    public N and() {
      return (N) ClusterVersionSpecFluent.this.setToOverrides(index,builder.build());
    }
    
    public N endOverride() {
      return and();
    }
    
  
  }
  public class SignatureStoresNested<N> extends SignatureStoreFluent<SignatureStoresNested<N>> implements Nested<N>{
    SignatureStoresNested(int index,SignatureStore item) {
      this.index = index;
      this.builder = new SignatureStoreBuilder(this, item);
    }
    SignatureStoreBuilder builder;
    int index;
    
    public N and() {
      return (N) ClusterVersionSpecFluent.this.setToSignatureStores(index,builder.build());
    }
    
    public N endSignatureStore() {
      return and();
    }
    
  
  }

}