package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class APIServerEncryptionFluent<A extends APIServerEncryptionFluent<A>> extends BaseFluent<A>{
  public APIServerEncryptionFluent() {
  }
  
  public APIServerEncryptionFluent(APIServerEncryption instance) {
    this.copyInstance(instance);
  }
  private KMSConfigBuilder kms;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(APIServerEncryption instance) {
    instance = (instance != null ? instance : new APIServerEncryption());
    if (instance != null) {
          this.withKms(instance.getKms());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public KMSConfig buildKms() {
    return this.kms != null ? this.kms.build() : null;
  }
  
  public A withKms(KMSConfig kms) {
    this._visitables.remove("kms");
    if (kms != null) {
        this.kms = new KMSConfigBuilder(kms);
        this._visitables.get("kms").add(this.kms);
    } else {
        this.kms = null;
        this._visitables.get("kms").remove(this.kms);
    }
    return (A) this;
  }
  
  public boolean hasKms() {
    return this.kms != null;
  }
  
  public KmsNested<A> withNewKms() {
    return new KmsNested(null);
  }
  
  public KmsNested<A> withNewKmsLike(KMSConfig item) {
    return new KmsNested(item);
  }
  
  public KmsNested<A> editKms() {
    return withNewKmsLike(java.util.Optional.ofNullable(buildKms()).orElse(null));
  }
  
  public KmsNested<A> editOrNewKms() {
    return withNewKmsLike(java.util.Optional.ofNullable(buildKms()).orElse(new KMSConfigBuilder().build()));
  }
  
  public KmsNested<A> editOrNewKmsLike(KMSConfig item) {
    return withNewKmsLike(java.util.Optional.ofNullable(buildKms()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    APIServerEncryptionFluent that = (APIServerEncryptionFluent) o;
    if (!java.util.Objects.equals(kms, that.kms)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(kms,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (kms != null) { sb.append("kms:"); sb.append(kms + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class KmsNested<N> extends KMSConfigFluent<KmsNested<N>> implements Nested<N>{
    KmsNested(KMSConfig item) {
      this.builder = new KMSConfigBuilder(this, item);
    }
    KMSConfigBuilder builder;
    
    public N and() {
      return (N) APIServerEncryptionFluent.this.withKms(builder.build());
    }
    
    public N endKms() {
      return and();
    }
    
  
  }

}