/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ComponentRouteStatus;
import io.fabric8.openshift.api.model.config.v1.ComponentRouteStatusBuilder;
import io.fabric8.openshift.api.model.config.v1.ComponentRouteStatusFluent;
import io.fabric8.openshift.api.model.config.v1.IngressStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class IngressStatusFluent<A extends IngressStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ComponentRouteStatusBuilder> componentRoutes = new ArrayList();
    private String defaultPlacement;
    private Map<String, Object> additionalProperties;

    public IngressStatusFluent() {
    }

    public IngressStatusFluent(IngressStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IngressStatus instance) {
        IngressStatus ingressStatus = instance = instance != null ? instance : new IngressStatus();
        if (instance != null) {
            this.withComponentRoutes(instance.getComponentRoutes());
            this.withDefaultPlacement(instance.getDefaultPlacement());
            this.withComponentRoutes(instance.getComponentRoutes());
            this.withDefaultPlacement(instance.getDefaultPlacement());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToComponentRoutes(int index, ComponentRouteStatus item) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList();
        }
        ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);
        if (index < 0 || index >= this.componentRoutes.size()) {
            this._visitables.get((Object)"componentRoutes").add(builder);
            this.componentRoutes.add(builder);
        } else {
            this._visitables.get((Object)"componentRoutes").add(index, builder);
            this.componentRoutes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToComponentRoutes(int index, ComponentRouteStatus item) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList();
        }
        ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);
        if (index < 0 || index >= this.componentRoutes.size()) {
            this._visitables.get((Object)"componentRoutes").add(builder);
            this.componentRoutes.add(builder);
        } else {
            this._visitables.get((Object)"componentRoutes").set(index, builder);
            this.componentRoutes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToComponentRoutes(ComponentRouteStatus ... items) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList();
        }
        for (ComponentRouteStatus item : items) {
            ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);
            this._visitables.get((Object)"componentRoutes").add(builder);
            this.componentRoutes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToComponentRoutes(Collection<ComponentRouteStatus> items) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList();
        }
        for (ComponentRouteStatus item : items) {
            ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);
            this._visitables.get((Object)"componentRoutes").add(builder);
            this.componentRoutes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromComponentRoutes(ComponentRouteStatus ... items) {
        if (this.componentRoutes == null) {
            return (A)((Object)this);
        }
        for (ComponentRouteStatus item : items) {
            ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);
            this._visitables.get((Object)"componentRoutes").remove((Object)builder);
            this.componentRoutes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromComponentRoutes(Collection<ComponentRouteStatus> items) {
        if (this.componentRoutes == null) {
            return (A)((Object)this);
        }
        for (ComponentRouteStatus item : items) {
            ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);
            this._visitables.get((Object)"componentRoutes").remove((Object)builder);
            this.componentRoutes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromComponentRoutes(Predicate<ComponentRouteStatusBuilder> predicate) {
        if (this.componentRoutes == null) {
            return (A)((Object)this);
        }
        Iterator<ComponentRouteStatusBuilder> each = this.componentRoutes.iterator();
        List visitables = this._visitables.get((Object)"componentRoutes");
        while (each.hasNext()) {
            ComponentRouteStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ComponentRouteStatus> buildComponentRoutes() {
        return this.componentRoutes != null ? IngressStatusFluent.build(this.componentRoutes) : null;
    }

    public ComponentRouteStatus buildComponentRoute(int index) {
        return this.componentRoutes.get(index).build();
    }

    public ComponentRouteStatus buildFirstComponentRoute() {
        return this.componentRoutes.get(0).build();
    }

    public ComponentRouteStatus buildLastComponentRoute() {
        return this.componentRoutes.get(this.componentRoutes.size() - 1).build();
    }

    public ComponentRouteStatus buildMatchingComponentRoute(Predicate<ComponentRouteStatusBuilder> predicate) {
        for (ComponentRouteStatusBuilder item : this.componentRoutes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingComponentRoute(Predicate<ComponentRouteStatusBuilder> predicate) {
        for (ComponentRouteStatusBuilder item : this.componentRoutes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withComponentRoutes(List<ComponentRouteStatus> componentRoutes) {
        if (this.componentRoutes != null) {
            this._visitables.get((Object)"componentRoutes").clear();
        }
        if (componentRoutes != null) {
            this.componentRoutes = new ArrayList();
            for (ComponentRouteStatus item : componentRoutes) {
                this.addToComponentRoutes(item);
            }
        } else {
            this.componentRoutes = null;
        }
        return (A)((Object)this);
    }

    public A withComponentRoutes(ComponentRouteStatus ... componentRoutes) {
        if (this.componentRoutes != null) {
            this.componentRoutes.clear();
            this._visitables.remove((Object)"componentRoutes");
        }
        if (componentRoutes != null) {
            for (ComponentRouteStatus item : componentRoutes) {
                this.addToComponentRoutes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasComponentRoutes() {
        return this.componentRoutes != null && !this.componentRoutes.isEmpty();
    }

    public ComponentRoutesNested<A> addNewComponentRoute() {
        return new ComponentRoutesNested(-1, null);
    }

    public ComponentRoutesNested<A> addNewComponentRouteLike(ComponentRouteStatus item) {
        return new ComponentRoutesNested(-1, item);
    }

    public ComponentRoutesNested<A> setNewComponentRouteLike(int index, ComponentRouteStatus item) {
        return new ComponentRoutesNested(index, item);
    }

    public ComponentRoutesNested<A> editComponentRoute(int index) {
        if (this.componentRoutes.size() <= index) {
            throw new RuntimeException("Can't edit componentRoutes. Index exceeds size.");
        }
        return this.setNewComponentRouteLike(index, this.buildComponentRoute(index));
    }

    public ComponentRoutesNested<A> editFirstComponentRoute() {
        if (this.componentRoutes.size() == 0) {
            throw new RuntimeException("Can't edit first componentRoutes. The list is empty.");
        }
        return this.setNewComponentRouteLike(0, this.buildComponentRoute(0));
    }

    public ComponentRoutesNested<A> editLastComponentRoute() {
        int index = this.componentRoutes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last componentRoutes. The list is empty.");
        }
        return this.setNewComponentRouteLike(index, this.buildComponentRoute(index));
    }

    public ComponentRoutesNested<A> editMatchingComponentRoute(Predicate<ComponentRouteStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.componentRoutes.size(); ++i) {
            if (!predicate.test(this.componentRoutes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching componentRoutes. No match found.");
        }
        return this.setNewComponentRouteLike(index, this.buildComponentRoute(index));
    }

    public String getDefaultPlacement() {
        return this.defaultPlacement;
    }

    public A withDefaultPlacement(String defaultPlacement) {
        this.defaultPlacement = defaultPlacement;
        return (A)((Object)this);
    }

    public boolean hasDefaultPlacement() {
        return this.defaultPlacement != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressStatusFluent that = (IngressStatusFluent)((Object)o);
        if (!Objects.equals(this.componentRoutes, that.componentRoutes)) {
            return false;
        }
        if (!Objects.equals(this.defaultPlacement, that.defaultPlacement)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.componentRoutes, this.defaultPlacement, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.componentRoutes != null && !this.componentRoutes.isEmpty()) {
            sb.append("componentRoutes:");
            sb.append(this.componentRoutes + ",");
        }
        if (this.defaultPlacement != null) {
            sb.append("defaultPlacement:");
            sb.append(this.defaultPlacement + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ComponentRoutesNested<N>
    extends ComponentRouteStatusFluent<ComponentRoutesNested<N>>
    implements Nested<N> {
        ComponentRouteStatusBuilder builder;
        int index;

        ComponentRoutesNested(int index, ComponentRouteStatus item) {
            this.index = index;
            this.builder = new ComponentRouteStatusBuilder(this, item);
        }

        public N and() {
            return (N)IngressStatusFluent.this.setToComponentRoutes(this.index, this.builder.build());
        }

        public N endComponentRoute() {
            return this.and();
        }
    }
}

