/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ExternalIPConfig;
import io.fabric8.openshift.api.model.config.v1.ExternalIPPolicy;
import io.fabric8.openshift.api.model.config.v1.ExternalIPPolicyBuilder;
import io.fabric8.openshift.api.model.config.v1.ExternalIPPolicyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ExternalIPConfigFluent<A extends ExternalIPConfigFluent<A>>
extends BaseFluent<A> {
    private List<String> autoAssignCIDRs = new ArrayList<String>();
    private ExternalIPPolicyBuilder policy;
    private Map<String, Object> additionalProperties;

    public ExternalIPConfigFluent() {
    }

    public ExternalIPConfigFluent(ExternalIPConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ExternalIPConfig instance) {
        ExternalIPConfig externalIPConfig = instance = instance != null ? instance : new ExternalIPConfig();
        if (instance != null) {
            this.withAutoAssignCIDRs(instance.getAutoAssignCIDRs());
            this.withPolicy(instance.getPolicy());
            this.withAutoAssignCIDRs(instance.getAutoAssignCIDRs());
            this.withPolicy(instance.getPolicy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAutoAssignCIDRs(int index, String item) {
        if (this.autoAssignCIDRs == null) {
            this.autoAssignCIDRs = new ArrayList<String>();
        }
        this.autoAssignCIDRs.add(index, item);
        return (A)((Object)this);
    }

    public A setToAutoAssignCIDRs(int index, String item) {
        if (this.autoAssignCIDRs == null) {
            this.autoAssignCIDRs = new ArrayList<String>();
        }
        this.autoAssignCIDRs.set(index, item);
        return (A)((Object)this);
    }

    public A addToAutoAssignCIDRs(String ... items) {
        if (this.autoAssignCIDRs == null) {
            this.autoAssignCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.autoAssignCIDRs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAutoAssignCIDRs(Collection<String> items) {
        if (this.autoAssignCIDRs == null) {
            this.autoAssignCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.autoAssignCIDRs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAutoAssignCIDRs(String ... items) {
        if (this.autoAssignCIDRs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.autoAssignCIDRs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAutoAssignCIDRs(Collection<String> items) {
        if (this.autoAssignCIDRs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.autoAssignCIDRs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAutoAssignCIDRs() {
        return this.autoAssignCIDRs;
    }

    public String getAutoAssignCIDR(int index) {
        return this.autoAssignCIDRs.get(index);
    }

    public String getFirstAutoAssignCIDR() {
        return this.autoAssignCIDRs.get(0);
    }

    public String getLastAutoAssignCIDR() {
        return this.autoAssignCIDRs.get(this.autoAssignCIDRs.size() - 1);
    }

    public String getMatchingAutoAssignCIDR(Predicate<String> predicate) {
        for (String item : this.autoAssignCIDRs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAutoAssignCIDR(Predicate<String> predicate) {
        for (String item : this.autoAssignCIDRs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAutoAssignCIDRs(List<String> autoAssignCIDRs) {
        if (autoAssignCIDRs != null) {
            this.autoAssignCIDRs = new ArrayList<String>();
            for (String item : autoAssignCIDRs) {
                this.addToAutoAssignCIDRs(item);
            }
        } else {
            this.autoAssignCIDRs = null;
        }
        return (A)((Object)this);
    }

    public A withAutoAssignCIDRs(String ... autoAssignCIDRs) {
        if (this.autoAssignCIDRs != null) {
            this.autoAssignCIDRs.clear();
            this._visitables.remove((Object)"autoAssignCIDRs");
        }
        if (autoAssignCIDRs != null) {
            for (String item : autoAssignCIDRs) {
                this.addToAutoAssignCIDRs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAutoAssignCIDRs() {
        return this.autoAssignCIDRs != null && !this.autoAssignCIDRs.isEmpty();
    }

    public ExternalIPPolicy buildPolicy() {
        return this.policy != null ? this.policy.build() : null;
    }

    public A withPolicy(ExternalIPPolicy policy) {
        this._visitables.remove((Object)this.policy);
        if (policy != null) {
            this.policy = new ExternalIPPolicyBuilder(policy);
            this._visitables.get((Object)"policy").add(this.policy);
        } else {
            this.policy = null;
            this._visitables.get((Object)"policy").remove((Object)this.policy);
        }
        return (A)((Object)this);
    }

    public boolean hasPolicy() {
        return this.policy != null;
    }

    public PolicyNested<A> withNewPolicy() {
        return new PolicyNested(null);
    }

    public PolicyNested<A> withNewPolicyLike(ExternalIPPolicy item) {
        return new PolicyNested(item);
    }

    public PolicyNested<A> editPolicy() {
        return this.withNewPolicyLike(Optional.ofNullable(this.buildPolicy()).orElse(null));
    }

    public PolicyNested<A> editOrNewPolicy() {
        return this.withNewPolicyLike(Optional.ofNullable(this.buildPolicy()).orElse(new ExternalIPPolicyBuilder().build()));
    }

    public PolicyNested<A> editOrNewPolicyLike(ExternalIPPolicy item) {
        return this.withNewPolicyLike(Optional.ofNullable(this.buildPolicy()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalIPConfigFluent that = (ExternalIPConfigFluent)((Object)o);
        if (!Objects.equals(this.autoAssignCIDRs, that.autoAssignCIDRs)) {
            return false;
        }
        if (!Objects.equals((Object)this.policy, (Object)that.policy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoAssignCIDRs, this.policy, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoAssignCIDRs != null && !this.autoAssignCIDRs.isEmpty()) {
            sb.append("autoAssignCIDRs:");
            sb.append(this.autoAssignCIDRs + ",");
        }
        if (this.policy != null) {
            sb.append("policy:");
            sb.append((Object)((Object)this.policy) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PolicyNested<N>
    extends ExternalIPPolicyFluent<PolicyNested<N>>
    implements Nested<N> {
        ExternalIPPolicyBuilder builder;

        PolicyNested(ExternalIPPolicy item) {
            this.builder = new ExternalIPPolicyBuilder(this, item);
        }

        public N and() {
            return (N)ExternalIPConfigFluent.this.withPolicy(this.builder.build());
        }

        public N endPolicy() {
            return this.and();
        }
    }
}

