package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TLSProfileSpecBuilder extends TLSProfileSpecFluent<TLSProfileSpecBuilder> implements VisitableBuilder<TLSProfileSpec,TLSProfileSpecBuilder>{
  public TLSProfileSpecBuilder() {
    this(new TLSProfileSpec());
  }
  
  public TLSProfileSpecBuilder(TLSProfileSpecFluent<?> fluent) {
    this(fluent, new TLSProfileSpec());
  }
  
  public TLSProfileSpecBuilder(TLSProfileSpecFluent<?> fluent,TLSProfileSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TLSProfileSpecBuilder(TLSProfileSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TLSProfileSpecFluent<?> fluent;
  
  public TLSProfileSpec build() {
    TLSProfileSpec buildable = new TLSProfileSpec(fluent.getCiphers(),fluent.getMinTLSVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}