package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OAuthTemplatesBuilder extends OAuthTemplatesFluent<OAuthTemplatesBuilder> implements VisitableBuilder<OAuthTemplates,OAuthTemplatesBuilder>{
  public OAuthTemplatesBuilder() {
    this(new OAuthTemplates());
  }
  
  public OAuthTemplatesBuilder(OAuthTemplatesFluent<?> fluent) {
    this(fluent, new OAuthTemplates());
  }
  
  public OAuthTemplatesBuilder(OAuthTemplatesFluent<?> fluent,OAuthTemplates instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OAuthTemplatesBuilder(OAuthTemplates instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OAuthTemplatesFluent<?> fluent;
  
  public OAuthTemplates build() {
    OAuthTemplates buildable = new OAuthTemplates(fluent.buildError(),fluent.buildLogin(),fluent.buildProviderSelection());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}