package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BasicAuthIdentityProviderBuilder extends BasicAuthIdentityProviderFluent<BasicAuthIdentityProviderBuilder> implements VisitableBuilder<BasicAuthIdentityProvider,BasicAuthIdentityProviderBuilder>{
  public BasicAuthIdentityProviderBuilder() {
    this(new BasicAuthIdentityProvider());
  }
  
  public BasicAuthIdentityProviderBuilder(BasicAuthIdentityProviderFluent<?> fluent) {
    this(fluent, new BasicAuthIdentityProvider());
  }
  
  public BasicAuthIdentityProviderBuilder(BasicAuthIdentityProviderFluent<?> fluent,BasicAuthIdentityProvider instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BasicAuthIdentityProviderBuilder(BasicAuthIdentityProvider instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BasicAuthIdentityProviderFluent<?> fluent;
  
  public BasicAuthIdentityProvider build() {
    BasicAuthIdentityProvider buildable = new BasicAuthIdentityProvider(fluent.buildCa(),fluent.buildTlsClientCert(),fluent.buildTlsClientKey(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}