package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ResourceLimitsBuilder extends ResourceLimitsFluent<ResourceLimitsBuilder> implements VisitableBuilder<ResourceLimits,ResourceLimitsBuilder>{
  public ResourceLimitsBuilder() {
    this(new ResourceLimits());
  }
  
  public ResourceLimitsBuilder(ResourceLimitsFluent<?> fluent) {
    this(fluent, new ResourceLimits());
  }
  
  public ResourceLimitsBuilder(ResourceLimitsFluent<?> fluent,ResourceLimits instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ResourceLimitsBuilder(ResourceLimits instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ResourceLimitsFluent<?> fluent;
  
  public ResourceLimits build() {
    ResourceLimits buildable = new ResourceLimits(fluent.buildCores(),fluent.buildGpus(),fluent.getMaxNodesTotal(),fluent.buildMemory());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}