package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterAutoscalerBuilder extends ClusterAutoscalerFluent<ClusterAutoscalerBuilder> implements VisitableBuilder<ClusterAutoscaler,ClusterAutoscalerBuilder>{
  public ClusterAutoscalerBuilder() {
    this(new ClusterAutoscaler());
  }
  
  public ClusterAutoscalerBuilder(ClusterAutoscalerFluent<?> fluent) {
    this(fluent, new ClusterAutoscaler());
  }
  
  public ClusterAutoscalerBuilder(ClusterAutoscalerFluent<?> fluent,ClusterAutoscaler instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterAutoscalerBuilder(ClusterAutoscaler instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterAutoscalerFluent<?> fluent;
  
  public ClusterAutoscaler build() {
    ClusterAutoscaler buildable = new ClusterAutoscaler(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}