package io.fabric8.openshift.api.model.clusterautoscaling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineAutoscalerListBuilder extends MachineAutoscalerListFluentImpl<MachineAutoscalerListBuilder> implements VisitableBuilder<MachineAutoscalerList,MachineAutoscalerListBuilder>{
  public MachineAutoscalerListBuilder() {
    this(false);
  }
  public MachineAutoscalerListBuilder(Boolean validationEnabled) {
    this(new MachineAutoscalerList(), validationEnabled);
  }
  public MachineAutoscalerListBuilder(MachineAutoscalerListFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineAutoscalerListBuilder(MachineAutoscalerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineAutoscalerList(), validationEnabled);
  }
  public MachineAutoscalerListBuilder(MachineAutoscalerListFluent<?> fluent,MachineAutoscalerList instance) {
    this(fluent, instance, false);
  }
  public MachineAutoscalerListBuilder(MachineAutoscalerListFluent<?> fluent,MachineAutoscalerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MachineAutoscalerListBuilder(MachineAutoscalerList instance) {
    this(instance,false);
  }
  public MachineAutoscalerListBuilder(MachineAutoscalerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  MachineAutoscalerListFluent<?> fluent;
  Boolean validationEnabled;
  public MachineAutoscalerList build() {
    MachineAutoscalerList buildable = new MachineAutoscalerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}