package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceRangeBuilder extends ResourceRangeFluentImpl<ResourceRangeBuilder> implements VisitableBuilder<ResourceRange,ResourceRangeBuilder>{
  public ResourceRangeBuilder() {
    this(false);
  }
  public ResourceRangeBuilder(Boolean validationEnabled) {
    this(new ResourceRange(), validationEnabled);
  }
  public ResourceRangeBuilder(ResourceRangeFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceRangeBuilder(ResourceRangeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceRange(), validationEnabled);
  }
  public ResourceRangeBuilder(ResourceRangeFluent<?> fluent,ResourceRange instance) {
    this(fluent, instance, false);
  }
  public ResourceRangeBuilder(ResourceRangeFluent<?> fluent,ResourceRange instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMax(instance.getMax()); 
    fluent.withMin(instance.getMin()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ResourceRangeBuilder(ResourceRange instance) {
    this(instance,false);
  }
  public ResourceRangeBuilder(ResourceRange instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMax(instance.getMax()); 
    this.withMin(instance.getMin()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ResourceRangeFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceRange build() {
    ResourceRange buildable = new ResourceRange(fluent.getMax(),fluent.getMin());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}