package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterAutoscalerSpecFluentImpl<A extends ClusterAutoscalerSpecFluent<A>> extends BaseFluent<A> implements ClusterAutoscalerSpecFluent<A>{
  public ClusterAutoscalerSpecFluentImpl() {
  }
  public ClusterAutoscalerSpecFluentImpl(ClusterAutoscalerSpec instance) {
    this.withBalanceSimilarNodeGroups(instance.getBalanceSimilarNodeGroups()); 
    this.withIgnoreDaemonsetsUtilization(instance.getIgnoreDaemonsetsUtilization()); 
    this.withMaxNodeProvisionTime(instance.getMaxNodeProvisionTime()); 
    this.withMaxPodGracePeriod(instance.getMaxPodGracePeriod()); 
    this.withPodPriorityThreshold(instance.getPodPriorityThreshold()); 
    this.withResourceLimits(instance.getResourceLimits()); 
    this.withScaleDown(instance.getScaleDown()); 
    this.withSkipNodesWithLocalStorage(instance.getSkipNodesWithLocalStorage()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Boolean balanceSimilarNodeGroups;
  private Boolean ignoreDaemonsetsUtilization;
  private String maxNodeProvisionTime;
  private Integer maxPodGracePeriod;
  private Integer podPriorityThreshold;
  private ResourceLimitsBuilder resourceLimits;
  private ScaleDownConfigBuilder scaleDown;
  private Boolean skipNodesWithLocalStorage;
  private Map<String,Object> additionalProperties;
  public Boolean getBalanceSimilarNodeGroups() {
    return this.balanceSimilarNodeGroups;
  }
  public A withBalanceSimilarNodeGroups(Boolean balanceSimilarNodeGroups) {
    this.balanceSimilarNodeGroups=balanceSimilarNodeGroups; return (A) this;
  }
  public Boolean hasBalanceSimilarNodeGroups() {
    return this.balanceSimilarNodeGroups != null;
  }
  public Boolean getIgnoreDaemonsetsUtilization() {
    return this.ignoreDaemonsetsUtilization;
  }
  public A withIgnoreDaemonsetsUtilization(Boolean ignoreDaemonsetsUtilization) {
    this.ignoreDaemonsetsUtilization=ignoreDaemonsetsUtilization; return (A) this;
  }
  public Boolean hasIgnoreDaemonsetsUtilization() {
    return this.ignoreDaemonsetsUtilization != null;
  }
  public String getMaxNodeProvisionTime() {
    return this.maxNodeProvisionTime;
  }
  public A withMaxNodeProvisionTime(String maxNodeProvisionTime) {
    this.maxNodeProvisionTime=maxNodeProvisionTime; return (A) this;
  }
  public Boolean hasMaxNodeProvisionTime() {
    return this.maxNodeProvisionTime != null;
  }
  public Integer getMaxPodGracePeriod() {
    return this.maxPodGracePeriod;
  }
  public A withMaxPodGracePeriod(Integer maxPodGracePeriod) {
    this.maxPodGracePeriod=maxPodGracePeriod; return (A) this;
  }
  public Boolean hasMaxPodGracePeriod() {
    return this.maxPodGracePeriod != null;
  }
  public Integer getPodPriorityThreshold() {
    return this.podPriorityThreshold;
  }
  public A withPodPriorityThreshold(Integer podPriorityThreshold) {
    this.podPriorityThreshold=podPriorityThreshold; return (A) this;
  }
  public Boolean hasPodPriorityThreshold() {
    return this.podPriorityThreshold != null;
  }
  
  /**
   * This method has been deprecated, please use method buildResourceLimits instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceLimits getResourceLimits() {
    return this.resourceLimits!=null ?this.resourceLimits.build():null;
  }
  public ResourceLimits buildResourceLimits() {
    return this.resourceLimits!=null ?this.resourceLimits.build():null;
  }
  public A withResourceLimits(ResourceLimits resourceLimits) {
    _visitables.get("resourceLimits").remove(this.resourceLimits);
    if (resourceLimits!=null){ this.resourceLimits= new ResourceLimitsBuilder(resourceLimits); _visitables.get("resourceLimits").add(this.resourceLimits);} else { this.resourceLimits = null; _visitables.get("resourceLimits").remove(this.resourceLimits); } return (A) this;
  }
  public Boolean hasResourceLimits() {
    return this.resourceLimits != null;
  }
  public ClusterAutoscalerSpecFluent.ResourceLimitsNested<A> withNewResourceLimits() {
    return new ClusterAutoscalerSpecFluentImpl.ResourceLimitsNestedImpl();
  }
  public ClusterAutoscalerSpecFluent.ResourceLimitsNested<A> withNewResourceLimitsLike(ResourceLimits item) {
    return new ClusterAutoscalerSpecFluentImpl.ResourceLimitsNestedImpl(item);
  }
  public ClusterAutoscalerSpecFluent.ResourceLimitsNested<A> editResourceLimits() {
    return withNewResourceLimitsLike(getResourceLimits());
  }
  public ClusterAutoscalerSpecFluent.ResourceLimitsNested<A> editOrNewResourceLimits() {
    return withNewResourceLimitsLike(getResourceLimits() != null ? getResourceLimits(): new ResourceLimitsBuilder().build());
  }
  public ClusterAutoscalerSpecFluent.ResourceLimitsNested<A> editOrNewResourceLimitsLike(ResourceLimits item) {
    return withNewResourceLimitsLike(getResourceLimits() != null ? getResourceLimits(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildScaleDown instead.
   * @return The buildable object.
   */
  @Deprecated
  public ScaleDownConfig getScaleDown() {
    return this.scaleDown!=null ?this.scaleDown.build():null;
  }
  public ScaleDownConfig buildScaleDown() {
    return this.scaleDown!=null ?this.scaleDown.build():null;
  }
  public A withScaleDown(ScaleDownConfig scaleDown) {
    _visitables.get("scaleDown").remove(this.scaleDown);
    if (scaleDown!=null){ this.scaleDown= new ScaleDownConfigBuilder(scaleDown); _visitables.get("scaleDown").add(this.scaleDown);} else { this.scaleDown = null; _visitables.get("scaleDown").remove(this.scaleDown); } return (A) this;
  }
  public Boolean hasScaleDown() {
    return this.scaleDown != null;
  }
  public A withNewScaleDown(String delayAfterAdd,String delayAfterDelete,String delayAfterFailure,Boolean enabled,String unneededTime) {
    return (A)withScaleDown(new ScaleDownConfig(delayAfterAdd, delayAfterDelete, delayAfterFailure, enabled, unneededTime));
  }
  public ClusterAutoscalerSpecFluent.ScaleDownNested<A> withNewScaleDown() {
    return new ClusterAutoscalerSpecFluentImpl.ScaleDownNestedImpl();
  }
  public ClusterAutoscalerSpecFluent.ScaleDownNested<A> withNewScaleDownLike(ScaleDownConfig item) {
    return new ClusterAutoscalerSpecFluentImpl.ScaleDownNestedImpl(item);
  }
  public ClusterAutoscalerSpecFluent.ScaleDownNested<A> editScaleDown() {
    return withNewScaleDownLike(getScaleDown());
  }
  public ClusterAutoscalerSpecFluent.ScaleDownNested<A> editOrNewScaleDown() {
    return withNewScaleDownLike(getScaleDown() != null ? getScaleDown(): new ScaleDownConfigBuilder().build());
  }
  public ClusterAutoscalerSpecFluent.ScaleDownNested<A> editOrNewScaleDownLike(ScaleDownConfig item) {
    return withNewScaleDownLike(getScaleDown() != null ? getScaleDown(): item);
  }
  public Boolean getSkipNodesWithLocalStorage() {
    return this.skipNodesWithLocalStorage;
  }
  public A withSkipNodesWithLocalStorage(Boolean skipNodesWithLocalStorage) {
    this.skipNodesWithLocalStorage=skipNodesWithLocalStorage; return (A) this;
  }
  public Boolean hasSkipNodesWithLocalStorage() {
    return this.skipNodesWithLocalStorage != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterAutoscalerSpecFluentImpl that = (ClusterAutoscalerSpecFluentImpl) o;
    if (balanceSimilarNodeGroups != null ? !balanceSimilarNodeGroups.equals(that.balanceSimilarNodeGroups) :that.balanceSimilarNodeGroups != null) return false;
    if (ignoreDaemonsetsUtilization != null ? !ignoreDaemonsetsUtilization.equals(that.ignoreDaemonsetsUtilization) :that.ignoreDaemonsetsUtilization != null) return false;
    if (maxNodeProvisionTime != null ? !maxNodeProvisionTime.equals(that.maxNodeProvisionTime) :that.maxNodeProvisionTime != null) return false;
    if (maxPodGracePeriod != null ? !maxPodGracePeriod.equals(that.maxPodGracePeriod) :that.maxPodGracePeriod != null) return false;
    if (podPriorityThreshold != null ? !podPriorityThreshold.equals(that.podPriorityThreshold) :that.podPriorityThreshold != null) return false;
    if (resourceLimits != null ? !resourceLimits.equals(that.resourceLimits) :that.resourceLimits != null) return false;
    if (scaleDown != null ? !scaleDown.equals(that.scaleDown) :that.scaleDown != null) return false;
    if (skipNodesWithLocalStorage != null ? !skipNodesWithLocalStorage.equals(that.skipNodesWithLocalStorage) :that.skipNodesWithLocalStorage != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(balanceSimilarNodeGroups,  ignoreDaemonsetsUtilization,  maxNodeProvisionTime,  maxPodGracePeriod,  podPriorityThreshold,  resourceLimits,  scaleDown,  skipNodesWithLocalStorage,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (balanceSimilarNodeGroups != null) { sb.append("balanceSimilarNodeGroups:"); sb.append(balanceSimilarNodeGroups + ","); }
    if (ignoreDaemonsetsUtilization != null) { sb.append("ignoreDaemonsetsUtilization:"); sb.append(ignoreDaemonsetsUtilization + ","); }
    if (maxNodeProvisionTime != null) { sb.append("maxNodeProvisionTime:"); sb.append(maxNodeProvisionTime + ","); }
    if (maxPodGracePeriod != null) { sb.append("maxPodGracePeriod:"); sb.append(maxPodGracePeriod + ","); }
    if (podPriorityThreshold != null) { sb.append("podPriorityThreshold:"); sb.append(podPriorityThreshold + ","); }
    if (resourceLimits != null) { sb.append("resourceLimits:"); sb.append(resourceLimits + ","); }
    if (scaleDown != null) { sb.append("scaleDown:"); sb.append(scaleDown + ","); }
    if (skipNodesWithLocalStorage != null) { sb.append("skipNodesWithLocalStorage:"); sb.append(skipNodesWithLocalStorage + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withBalanceSimilarNodeGroups() {
    return withBalanceSimilarNodeGroups(true);
  }
  public A withIgnoreDaemonsetsUtilization() {
    return withIgnoreDaemonsetsUtilization(true);
  }
  public A withSkipNodesWithLocalStorage() {
    return withSkipNodesWithLocalStorage(true);
  }
  class ResourceLimitsNestedImpl<N> extends ResourceLimitsFluentImpl<ClusterAutoscalerSpecFluent.ResourceLimitsNested<N>> implements ClusterAutoscalerSpecFluent.ResourceLimitsNested<N>,Nested<N>{
    ResourceLimitsNestedImpl(ResourceLimits item) {
      this.builder = new ResourceLimitsBuilder(this, item);
    }
    ResourceLimitsNestedImpl() {
      this.builder = new ResourceLimitsBuilder(this);
    }
    ResourceLimitsBuilder builder;
    public N and() {
      return (N) ClusterAutoscalerSpecFluentImpl.this.withResourceLimits(builder.build());
    }
    public N endResourceLimits() {
      return and();
    }
    
  }
  class ScaleDownNestedImpl<N> extends ScaleDownConfigFluentImpl<ClusterAutoscalerSpecFluent.ScaleDownNested<N>> implements ClusterAutoscalerSpecFluent.ScaleDownNested<N>,Nested<N>{
    ScaleDownNestedImpl(ScaleDownConfig item) {
      this.builder = new ScaleDownConfigBuilder(this, item);
    }
    ScaleDownNestedImpl() {
      this.builder = new ScaleDownConfigBuilder(this);
    }
    ScaleDownConfigBuilder builder;
    public N and() {
      return (N) ClusterAutoscalerSpecFluentImpl.this.withScaleDown(builder.build());
    }
    public N endScaleDown() {
      return and();
    }
    
  }
  
}