/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.operators.coreos;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.operatorhub.v1.Operator;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.operators.coreos.OperatorOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class OperatorHandler
implements ResourceHandler<Operator, OperatorBuilder> {
    public String getKind() {
        return Operator.class.getSimpleName();
    }

    public String getApiVersion() {
        return "operators.coreos.com/v1";
    }

    public Operator create(OkHttpClient client, Config config, String namespace, Operator item, boolean dryRun) {
        return (Operator)((WritableOperation)new OperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new Operator[0]);
    }

    public Operator replace(OkHttpClient client, Config config, String namespace, Operator item, boolean dryRun) {
        return (Operator)((WritableOperation)((Resource)new OperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public Operator reload(OkHttpClient client, Config config, String namespace, Operator item) {
        return (Operator)((Gettable)((Resource)new OperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public OperatorBuilder edit(Operator item) {
        return new OperatorBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Operator item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new OperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Operator item, Watcher<Operator> watcher) {
        return ((Resource)new OperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Operator item, String resourceVersion, Watcher<Operator> watcher) {
        return ((Resource)new OperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Operator item, ListOptions options, Watcher<Operator> watcher) {
        return ((Resource)new OperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public Operator waitUntilReady(OkHttpClient client, Config config, String namespace, Operator item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Operator)((Resource)new OperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public Operator waitUntilCondition(OkHttpClient client, Config config, String namespace, Operator item, Predicate<Operator> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Operator)((Resource)new OperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

