/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.operator;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.operator.v1.CloudCredential;
import io.fabric8.openshift.api.model.operator.v1.CloudCredentialBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.operator.CloudCredentialOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class CloudCredentialHandler
implements ResourceHandler<CloudCredential, CloudCredentialBuilder> {
    public String getKind() {
        return CloudCredential.class.getSimpleName();
    }

    public String getApiVersion() {
        return "operator.openshift.io/v1";
    }

    public CloudCredential create(OkHttpClient client, Config config, String namespace, CloudCredential item, boolean dryRun) {
        return (CloudCredential)((WritableOperation)new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new CloudCredential[0]);
    }

    public CloudCredential replace(OkHttpClient client, Config config, String namespace, CloudCredential item, boolean dryRun) {
        return (CloudCredential)((WritableOperation)((Resource)new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public CloudCredential reload(OkHttpClient client, Config config, String namespace, CloudCredential item) {
        return (CloudCredential)((Gettable)((Resource)new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public CloudCredentialBuilder edit(CloudCredential item) {
        return new CloudCredentialBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, CloudCredential item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, CloudCredential item, Watcher<CloudCredential> watcher) {
        return ((Resource)new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, CloudCredential item, String resourceVersion, Watcher<CloudCredential> watcher) {
        return ((Resource)new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, CloudCredential item, ListOptions options, Watcher<CloudCredential> watcher) {
        return ((Resource)new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public CloudCredential waitUntilReady(OkHttpClient client, Config config, String namespace, CloudCredential item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (CloudCredential)((Resource)new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public CloudCredential waitUntilCondition(OkHttpClient client, Config config, String namespace, CloudCredential item, Predicate<CloudCredential> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (CloudCredential)((Resource)new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

