/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.config;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.OAuth;
import io.fabric8.openshift.api.model.OAuthBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.config.OAuthOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class OAuthHandler
implements ResourceHandler<OAuth, OAuthBuilder> {
    public String getKind() {
        return OAuth.class.getSimpleName();
    }

    public String getApiVersion() {
        return "config.openshift.io/v1";
    }

    public OAuth create(OkHttpClient client, Config config, String namespace, OAuth item, boolean dryRun) {
        return (OAuth)((WritableOperation)new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new OAuth[0]);
    }

    public OAuth replace(OkHttpClient client, Config config, String namespace, OAuth item, boolean dryRun) {
        return (OAuth)((WritableOperation)((Resource)new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public OAuth reload(OkHttpClient client, Config config, String namespace, OAuth item) {
        return (OAuth)((Gettable)((Resource)new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public OAuthBuilder edit(OAuth item) {
        return new OAuthBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, OAuth item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, OAuth item, Watcher<OAuth> watcher) {
        return ((Resource)new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, OAuth item, String resourceVersion, Watcher<OAuth> watcher) {
        return ((Resource)new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, OAuth item, ListOptions options, Watcher<OAuth> watcher) {
        return ((Resource)new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public OAuth waitUntilReady(OkHttpClient client, Config config, String namespace, OAuth item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (OAuth)((Resource)new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public OAuth waitUntilCondition(OkHttpClient client, Config config, String namespace, OAuth item, Predicate<OAuth> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (OAuth)((Resource)new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

