/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.network;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.NetNamespace;
import io.fabric8.openshift.api.model.NetNamespaceBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.network.NetNamespaceOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class NetNamespaceHandler
implements ResourceHandler<NetNamespace, NetNamespaceBuilder> {
    public String getKind() {
        return NetNamespace.class.getSimpleName();
    }

    public String getApiVersion() {
        return "network.openshift.io/v1";
    }

    public NetNamespace create(OkHttpClient client, Config config, String namespace, NetNamespace item, boolean dryRun) {
        return (NetNamespace)((WritableOperation)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new NetNamespace[0]);
    }

    public NetNamespace replace(OkHttpClient client, Config config, String namespace, NetNamespace item, boolean dryRun) {
        return (NetNamespace)((WritableOperation)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public NetNamespace reload(OkHttpClient client, Config config, String namespace, NetNamespace item) {
        return (NetNamespace)((Gettable)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public NetNamespaceBuilder edit(NetNamespace item) {
        return new NetNamespaceBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, NetNamespace item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, NetNamespace item, Watcher<NetNamespace> watcher) {
        return ((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, NetNamespace item, String resourceVersion, Watcher<NetNamespace> watcher) {
        return ((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, NetNamespace item, ListOptions options, Watcher<NetNamespace> watcher) {
        return ((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public NetNamespace waitUntilReady(OkHttpClient client, Config config, String namespace, NetNamespace item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (NetNamespace)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public NetNamespace waitUntilCondition(OkHttpClient client, Config config, String namespace, NetNamespace item, Predicate<NetNamespace> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (NetNamespace)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

