/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.Subscription;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.SubscriptionOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class SubscriptionHandler
implements ResourceHandler<Subscription, SubscriptionBuilder> {
    public String getKind() {
        return Subscription.class.getSimpleName();
    }

    public String getApiVersion() {
        return "operators.coreos.com/v1alpha1";
    }

    public Subscription create(OkHttpClient client, Config config, String namespace, Subscription item, boolean dryRun) {
        return (Subscription)((WritableOperation)new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new Subscription[0]);
    }

    public Subscription replace(OkHttpClient client, Config config, String namespace, Subscription item, boolean dryRun) {
        return (Subscription)((WritableOperation)((Resource)new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public Subscription reload(OkHttpClient client, Config config, String namespace, Subscription item) {
        return (Subscription)((Gettable)((Resource)new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public SubscriptionBuilder edit(Subscription item) {
        return new SubscriptionBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Subscription item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Subscription item, Watcher<Subscription> watcher) {
        return ((Resource)new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Subscription item, String resourceVersion, Watcher<Subscription> watcher) {
        return ((Resource)new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Subscription item, ListOptions options, Watcher<Subscription> watcher) {
        return ((Resource)new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public Subscription waitUntilReady(OkHttpClient client, Config config, String namespace, Subscription item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Subscription)((Resource)new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public Subscription waitUntilCondition(OkHttpClient client, Config config, String namespace, Subscription item, Predicate<Subscription> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Subscription)((Resource)new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

