/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client;

import io.fabric8.kubernetes.api.model.APIGroupList;
import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.ClientContext;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftNotAvailableException;
import io.fabric8.openshift.client.internal.OpenShiftOAuthInterceptor;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OpenshiftAdapterSupport {
    private static final Map<String, Boolean> API_GROUPS_ENABLED_PER_URL = new ConcurrentHashMap<String, Boolean>();

    public Boolean isAdaptable(Client client) {
        OpenShiftConfig config = OpenShiftConfig.wrap(client.getConfiguration());
        return OpenshiftAdapterSupport.hasCustomOpenShiftUrl(config) || OpenshiftAdapterSupport.isOpenShiftAPIGroups(client.getHttpClient(), config);
    }

    public DefaultOpenShiftClient adapt(Client client) {
        if (!this.isAdaptable(client).booleanValue()) {
            throw new OpenShiftNotAvailableException("OpenShift is not available. Root paths at: " + client.getMasterUrl() + " do not include oapi.");
        }
        return new DefaultOpenShiftClient((ClientContext)client);
    }

    public static boolean isOpenShiftAPIGroups(HttpClient client, OpenShiftConfig config) {
        if (config.isDisableApiGroupCheck()) {
            return true;
        }
        String url = config.getMasterUrl();
        return API_GROUPS_ENABLED_PER_URL.computeIfAbsent(url, k -> {
            APIGroupList apiGroups = new BaseClient(OpenshiftAdapterSupport.adaptHttpClient(client, config), (Config)config).getApiGroups();
            if (apiGroups == null) {
                return false;
            }
            return apiGroups.getGroups().stream().anyMatch(g -> g.getName().endsWith("openshift.io"));
        });
    }

    static boolean hasCustomOpenShiftUrl(OpenShiftConfig config) {
        try {
            URI masterUri = new URI(config.getMasterUrl()).resolve("/");
            URI openshfitUri = new URI(config.getOpenShiftUrl()).resolve("/");
            return !masterUri.equals(openshfitUri);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public static HttpClient adaptHttpClient(HttpClient httpClient, OpenShiftConfig config) {
        if (httpClient == null) {
            httpClient = HttpClientUtils.createHttpClient((Config)config);
        }
        HttpClient.Builder builder = httpClient.newBuilder().authenticatorNone();
        return builder.addOrReplaceInterceptor("TOKEN", (Interceptor)new OpenShiftOAuthInterceptor(httpClient, config)).build();
    }
}

