/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.monitoring.v1.Prometheus;
import io.fabric8.openshift.api.model.monitoring.v1.PrometheusBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.PrometheusOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class PrometheusHandler
implements ResourceHandler<Prometheus, PrometheusBuilder> {
    public String getKind() {
        return Prometheus.class.getSimpleName();
    }

    public String getApiVersion() {
        return "monitoring.coreos.com/v1";
    }

    public Prometheus create(OkHttpClient client, Config config, String namespace, Prometheus item) {
        return (Prometheus)new PrometheusOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new Prometheus[0]);
    }

    public Prometheus replace(OkHttpClient client, Config config, String namespace, Prometheus item) {
        return (Prometheus)((Resource)new PrometheusOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public Prometheus reload(OkHttpClient client, Config config, String namespace, Prometheus item) {
        return (Prometheus)((Gettable)((Resource)new PrometheusOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public PrometheusBuilder edit(Prometheus item) {
        return new PrometheusBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Prometheus item) {
        return new PrometheusOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).withPropagationPolicy(propagationPolicy).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Prometheus item, Watcher<Prometheus> watcher) {
        return ((Resource)new PrometheusOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Prometheus item, String resourceVersion, Watcher<Prometheus> watcher) {
        return ((Resource)new PrometheusOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Prometheus item, ListOptions options, Watcher<Prometheus> watcher) {
        return ((Resource)new PrometheusOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public Prometheus waitUntilReady(OkHttpClient client, Config config, String namespace, Prometheus item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Prometheus)((Resource)new PrometheusOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public Prometheus waitUntilCondition(OkHttpClient client, Config config, String namespace, Prometheus item, Predicate<Prometheus> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Prometheus)((Resource)new PrometheusOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

