/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.ImageStreamTagBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.ImageStreamTagOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ImageStreamTagHandler
implements ResourceHandler<ImageStreamTag, ImageStreamTagBuilder> {
    public String getKind() {
        return ImageStreamTag.class.getSimpleName();
    }

    public String getApiVersion() {
        return "image.openshift.io/v1";
    }

    public ImageStreamTag create(OkHttpClient client, Config config, String namespace, ImageStreamTag item) {
        return (ImageStreamTag)new ImageStreamTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new ImageStreamTag[0]);
    }

    public ImageStreamTag replace(OkHttpClient client, Config config, String namespace, ImageStreamTag item) {
        return (ImageStreamTag)((Resource)new ImageStreamTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public ImageStreamTag reload(OkHttpClient client, Config config, String namespace, ImageStreamTag item) {
        return (ImageStreamTag)((Gettable)((Resource)new ImageStreamTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ImageStreamTagBuilder edit(ImageStreamTag item) {
        return new ImageStreamTagBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ImageStreamTag item) {
        return new ImageStreamTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).withPropagationPolicy(propagationPolicy).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ImageStreamTag item, Watcher<ImageStreamTag> watcher) {
        return ((Resource)new ImageStreamTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ImageStreamTag item, String resourceVersion, Watcher<ImageStreamTag> watcher) {
        return ((Resource)new ImageStreamTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ImageStreamTag item, ListOptions options, Watcher<ImageStreamTag> watcher) {
        return ((Resource)new ImageStreamTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public ImageStreamTag waitUntilReady(OkHttpClient client, Config config, String namespace, ImageStreamTag item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ImageStreamTag)((Resource)new ImageStreamTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public ImageStreamTag waitUntilCondition(OkHttpClient client, Config config, String namespace, ImageStreamTag item, Predicate<ImageStreamTag> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ImageStreamTag)((Resource)new ImageStreamTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

