/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RoleBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.RoleOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class RoleHandler
implements ResourceHandler<Role, RoleBuilder> {
    public String getKind() {
        return Role.class.getSimpleName();
    }

    public String getApiVersion() {
        return "authorization.openshift.io/v1";
    }

    public Role create(OkHttpClient client, Config config, String namespace, Role item) {
        return (Role)new RoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new Role[0]);
    }

    public Role replace(OkHttpClient client, Config config, String namespace, Role item) {
        return (Role)((Resource)new RoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public Role reload(OkHttpClient client, Config config, String namespace, Role item) {
        return (Role)((Gettable)((Resource)new RoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public RoleBuilder edit(Role item) {
        return new RoleBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Role item) {
        return new RoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).withPropagationPolicy(propagationPolicy).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Role item, Watcher<Role> watcher) {
        return ((Resource)new RoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Role item, String resourceVersion, Watcher<Role> watcher) {
        return ((Resource)new RoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Role item, ListOptions options, Watcher<Role> watcher) {
        return ((Resource)new RoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public Role waitUntilReady(OkHttpClient client, Config config, String namespace, Role item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Role)((Resource)new RoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public Role waitUntilCondition(OkHttpClient client, Config config, String namespace, Role item, Predicate<Role> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Role)((Resource)new RoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

