/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import okhttp3.OkHttpClient;

public class BuildOperationContext
extends OperationContext {
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private PipedOutputStream inPipe;
    private PipedInputStream outPipe;
    private PipedInputStream errPipe;
    private boolean tty;
    private boolean terminatedStatus;
    private boolean timestamps;
    private String sinceTimestamp;
    private Integer sinceSeconds;
    private Integer tailingLines;
    private boolean prettyOutput;
    private Integer limitBytes;
    private String version;

    public BuildOperationContext() {
    }

    public BuildOperationContext(OkHttpClient client, Config config, String plural, String namespace, String name, String apiGroupName, String apiGroupVersion, Boolean cascading, Object item, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, InputStream in, OutputStream out, OutputStream err, PipedOutputStream inPipe, PipedInputStream outPipe, PipedInputStream errPipe, Boolean tty, Boolean terminatedStatus, Boolean timestampes, String sinceTimestamp, Integer sinceSeconds, Integer tailingLines, Boolean prettyOutput, Integer limitBytes, String version) {
        super(client, config, plural, namespace, name, apiGroupName, apiGroupVersion, cascading.booleanValue(), item, labels, labelsNot, labelsIn, labelsNotIn, fields, resourceVersion, reloadingFromServer.booleanValue(), gracePeriodSeconds);
        this.in = in;
        this.out = out;
        this.err = err;
        this.inPipe = inPipe;
        this.outPipe = outPipe;
        this.errPipe = errPipe;
        this.tty = tty;
        this.terminatedStatus = terminatedStatus;
        this.timestamps = true;
        this.sinceTimestamp = sinceTimestamp;
        this.sinceSeconds = sinceSeconds;
        this.tailingLines = tailingLines;
        this.prettyOutput = prettyOutput;
        this.limitBytes = limitBytes;
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public InputStream getIn() {
        return this.in;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public OutputStream getErr() {
        return this.err;
    }

    public PipedOutputStream getInPipe() {
        return this.inPipe;
    }

    public PipedInputStream getOutPipe() {
        return this.outPipe;
    }

    public PipedInputStream getErrPipe() {
        return this.errPipe;
    }

    public boolean isTty() {
        return this.tty;
    }

    public boolean isTerminatedStatus() {
        return this.terminatedStatus;
    }

    public boolean isTimestamps() {
        return this.timestamps;
    }

    public String getSinceTimestamp() {
        return this.sinceTimestamp;
    }

    public Integer getSinceSeconds() {
        return this.sinceSeconds;
    }

    public Integer getTailingLines() {
        return this.tailingLines;
    }

    public boolean isPrettyOutput() {
        return this.prettyOutput;
    }

    public Integer getLimitBytes() {
        return this.limitBytes;
    }

    public BuildOperationContext withOkhttpClient(OkHttpClient client) {
        return new BuildOperationContext(client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withConfig(Config config) {
        return new BuildOperationContext(this.client, OpenShiftConfig.wrap(config), this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withPlural(String plural) {
        return new BuildOperationContext(this.client, this.config, plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withNamespace(String namespace) {
        return new BuildOperationContext(this.client, this.config, this.plural, namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withName(String name) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withApiGroupName(String apiGroupName) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withApiGroupVersion(String apiGroupVersion) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withItem(Object item) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withCascading(boolean cascading) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withLabels(Map<String, String> labels) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withLabelsIn(Map<String, String[]> labelsIn) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withLabelsNot(Map<String, String> labelsNot) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withLabelsNotIn(Map<String, String[]> labelsNotIn) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withFields(Map<String, String> fields) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withResourceVersion(String resourceVersion) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withReloadingFromServer(boolean reloadingFromServer) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withGracePeriodSeconds(long gracePeriodSeconds) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withIn(InputStream in) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withOut(OutputStream out) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withErr(OutputStream err) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withInPipe(PipedOutputStream inPipe) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withOutPipe(PipedInputStream outPipe) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withErrPipe(PipedInputStream errPipe) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withTty(boolean tty) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withTerminatedStatus(boolean terminatedStatus) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withTimestamps(boolean timestamps) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withSinceTimestamp(String sinceTimestamp) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withSinceSeconds(Integer sinceSeconds) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, sinceSeconds, this.tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withTailingLines(Integer tailingLines) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, tailingLines, this.prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withPrettyOutput(boolean prettyOutput) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, prettyOutput, this.limitBytes, this.version);
    }

    public BuildOperationContext withLimitBytes(Integer limitBytes) {
        return new BuildOperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.tty, this.terminatedStatus, this.timestamps, this.sinceTimestamp, this.sinceSeconds, this.tailingLines, this.prettyOutput, limitBytes, this.version);
    }
}

