/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ClusterVersion;
import io.fabric8.openshift.api.model.ClusterVersionBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.ClusterVersionOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ClusterVersionHandler
implements ResourceHandler<ClusterVersion, ClusterVersionBuilder> {
    public String getKind() {
        return ClusterVersion.class.getSimpleName();
    }

    public String getApiVersion() {
        return "config.openshift.io/v1";
    }

    public ClusterVersion create(OkHttpClient client, Config config, String namespace, ClusterVersion item) {
        return (ClusterVersion)new ClusterVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create((Object[])new ClusterVersion[0]);
    }

    public ClusterVersion replace(OkHttpClient client, Config config, String namespace, ClusterVersion item) {
        return (ClusterVersion)((Resource)new ClusterVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public ClusterVersion reload(OkHttpClient client, Config config, String namespace, ClusterVersion item) {
        return (ClusterVersion)((Gettable)((Resource)new ClusterVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ClusterVersionBuilder edit(ClusterVersion item) {
        return new ClusterVersionBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ClusterVersion item) {
        return (Boolean)new ClusterVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterVersion item, Watcher<ClusterVersion> watcher) {
        return (Watch)((Resource)new ClusterVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterVersion item, String resourceVersion, Watcher<ClusterVersion> watcher) {
        return (Watch)((Resource)new ClusterVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public ClusterVersion waitUntilReady(OkHttpClient client, Config config, String namespace, ClusterVersion item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ClusterVersion)((Resource)new ClusterVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public ClusterVersion waitUntilCondition(OkHttpClient client, Config config, String namespace, ClusterVersion item, Predicate<ClusterVersion> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ClusterVersion)((Resource)new ClusterVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

