/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Reaper;
import io.fabric8.kubernetes.client.dsl.Triggerable;
import io.fabric8.kubernetes.client.dsl.Typeable;
import io.fabric8.kubernetes.client.dsl.Watchable;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.WebHookTrigger;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.BuildConfigOperation;
import io.fabric8.openshift.client.dsl.ClientBuildConfigResource;
import io.fabric8.openshift.client.dsl.internal.BuildOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;

public class BuildConfigOperationsImpl
extends OpenShiftOperation<BuildConfig, BuildConfigList, DoneableBuildConfig, ClientBuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Build>>
implements BuildConfigOperation {
    public static final String BUILD_CONFIG_LABEL = "openshift.io/build-config.name";
    public static final String BUILD_CONFIG_ANNOTATION = "openshift.io/build-config.name";
    private final String secret;
    private final String triggerType;

    public BuildConfigOperationsImpl(OkHttpClient client, OpenShiftConfig config, String namespace) {
        this(client, config, null, namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null);
    }

    public BuildConfigOperationsImpl(OkHttpClient client, OpenShiftConfig config, String apiVersion, String namespace, String name, Boolean cascading, BuildConfig item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        this(client, config, apiVersion, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields, null, null);
    }

    public BuildConfigOperationsImpl(OkHttpClient client, OpenShiftConfig config, String apiVersion, String namespace, String name, Boolean cascading, BuildConfig item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, String secret, String triggerType) {
        super(client, config, null, apiVersion, "buildconfigs", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.triggerType = triggerType;
        this.secret = secret;
        this.reaper = new BuildConfigReaper(this);
    }

    public ClientBuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Build> withName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be provided.");
        }
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), name, this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType);
    }

    @Override
    public OpenShiftOperation<BuildConfig, BuildConfigList, DoneableBuildConfig, ClientBuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Build>> inNamespace(String namespace) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), namespace, this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType);
    }

    public Gettable<BuildConfig> fromServer() {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.namespace, this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), true, this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType);
    }

    public Typeable<Triggerable<WebHookTrigger, Void>> withSecret(String secret) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), secret, this.triggerType);
    }

    public ClientBuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Build> load(InputStream is) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)BuildConfigOperationsImpl.unmarshal((InputStream)is, (Class)this.getType()), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType);
    }

    public Build instantiate(BuildRequest request) {
        try {
            URL instantiationUrl = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "instantiate"}));
            RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)BaseOperation.JSON_MAPPER.writer().writeValueAsString((Object)request));
            Request.Builder requestBuilder = new Request.Builder().post(requestBody).url(instantiationUrl);
            return (Build)this.handleResponse(requestBuilder, 201, Build.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public Void trigger(WebHookTrigger trigger) {
        try {
            String triggerUrl = URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "webhooks", this.secret, this.triggerType});
            RequestBody requestBody = RequestBody.create((MediaType)JSON, (byte[])BaseOperation.JSON_MAPPER.writer().writeValueAsBytes((Object)trigger));
            Request.Builder requestBuilder = new Request.Builder().post(requestBody).url(triggerUrl).addHeader("X-Github-Event", "push");
            this.handleResponse(requestBuilder, 200, null);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        return null;
    }

    public Triggerable<WebHookTrigger, Void> withType(String type) {
        return new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (BuildConfig)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, type);
    }

    public Watchable<Watch, Watcher<BuildConfig>> withResourceVersion(String resourceVersion) {
        BuildConfigOperationsImpl buildConfigOperations = new BuildConfigOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.namespace, this.getName(), this.isCascading(), (BuildConfig)this.getItem(), resourceVersion, this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.secret, this.triggerType);
        return buildConfigOperations;
    }

    private void deleteBuilds() {
        String buildConfigLabelValue = this.getName().substring(0, Math.min(this.getName().length(), 63));
        BuildList matchingBuilds = (BuildList)new BuildOperationsImpl(this.client, (OpenShiftConfig)this.config, this.namespace).inNamespace(this.namespace).withLabel("openshift.io/build-config.name", buildConfigLabelValue).list();
        if (matchingBuilds.getItems() != null) {
            for (Build matchingBuild : matchingBuilds.getItems()) {
                if (matchingBuild.getMetadata() == null || matchingBuild.getMetadata().getAnnotations() == null || !this.getName().equals(matchingBuild.getMetadata().getAnnotations().get("openshift.io/build-config.name"))) continue;
                new BuildOperationsImpl(this.client, (OpenShiftConfig)this.config, this.namespace).inNamespace(matchingBuild.getMetadata().getNamespace()).withName(matchingBuild.getMetadata().getName()).delete();
            }
        }
    }

    private static class BuildConfigReaper
    implements Reaper {
        private BuildConfigOperationsImpl oper;

        public BuildConfigReaper(BuildConfigOperationsImpl oper) {
            this.oper = oper;
        }

        public void reap() {
            this.oper.deleteBuilds();
        }
    }
}

