/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import com.ning.http.client.AsyncHttpClient;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.openshift.api.model.DoneableTemplate;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.ParameterValue;
import io.fabric8.openshift.client.dsl.ClientTemplateResource;
import io.fabric8.openshift.client.dsl.TemplateOperation;
import io.fabric8.openshift.client.dsl.internal.OpenshiftOperation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

public class TemplateOperationsImpl
extends OpenshiftOperation<OpenShiftClient, Template, TemplateList, DoneableTemplate, ClientTemplateResource<Template, KubernetesList, DoneableTemplate>>
implements TemplateOperation {
    public TemplateOperationsImpl(OpenShiftClient client) {
        this(client, null, null, true, null);
    }

    public TemplateOperationsImpl(OpenShiftClient client, String namespace, String name, Boolean cascading, Template item) {
        super(client, "templates", namespace, name, cascading, item);
    }

    @Override
    public KubernetesList process(ParameterValue ... values) {
        Template t = (Template)this.get();
        AsyncHttpClient.BoundRequestBuilder requestBuilder = null;
        HashMap<String, String> valuesMap = new HashMap<String, String>(values.length);
        for (ParameterValue pv : values) {
            valuesMap.put(pv.getName(), pv.getValue());
        }
        try {
            for (Parameter p : t.getParameters()) {
                String v = (String)valuesMap.get(p.getName());
                if (v == null) continue;
                p.setGenerate(null);
                p.setValue(v);
            }
            requestBuilder = ((OpenShiftClient)this.getClient()).getHttpClient().preparePost(this.getProcessUrl().toString());
            requestBuilder.setBody(mapper.writer().writeValueAsString((Object)t));
            t = (Template)this.handleResponse(requestBuilder, 201);
            KubernetesList l = new KubernetesList();
            l.setItems(t.getObjects());
            return l;
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    private URL getProcessUrl() throws MalformedURLException {
        URL requestUrl = this.getRootUrl();
        if (this.getNamespace() != null) {
            requestUrl = new URL(requestUrl, "namespaces/" + this.getNamespace() + "/");
        }
        requestUrl = new URL(requestUrl, "processedtemplates/");
        return requestUrl;
    }
}

