/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.openshift.api.model.DoneableTemplate;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.ParameterValue;
import io.fabric8.openshift.client.dsl.ClientTemplateResource;
import io.fabric8.openshift.client.dsl.TemplateOperation;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class TemplateOperationsImpl
extends OpenShiftOperation<Template, TemplateList, DoneableTemplate, ClientTemplateResource<Template, KubernetesList, DoneableTemplate>>
implements TemplateOperation {
    public TemplateOperationsImpl(OkHttpClient client, OpenShiftConfig config, String namespace) {
        this(client, config, null, namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public TemplateOperationsImpl(OkHttpClient client, OpenShiftConfig config, String apiVersion, String namespace, String name, Boolean cascading, Template item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config, null, apiVersion, "templates", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
    }

    @Override
    public KubernetesList process(ParameterValue ... values) {
        Template t = (Template)this.get();
        HashMap<String, String> valuesMap = new HashMap<String, String>(values.length);
        for (ParameterValue pv : values) {
            valuesMap.put(pv.getName(), pv.getValue());
        }
        try {
            for (Parameter p : t.getParameters()) {
                String v = (String)valuesMap.get(p.getName());
                if (v == null) continue;
                p.setGenerate(null);
                p.setValue(v);
            }
            RequestBody body = RequestBody.create((MediaType)JSON, (String)JSON_MAPPER.writeValueAsString((Object)t));
            Request.Builder requestBuilder = new Request.Builder().post(body).url(this.getProcessUrl());
            t = (Template)this.handleResponse(requestBuilder, 201);
            KubernetesList l = new KubernetesList();
            l.setItems(t.getObjects());
            return l;
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    private URL getProcessUrl() throws MalformedURLException {
        URL requestUrl = this.getRootUrl();
        if (this.getNamespace() != null) {
            requestUrl = new URL(URLUtils.join((String[])new String[]{requestUrl.toString(), "namespaces", this.getNamespace()}));
        }
        requestUrl = new URL(URLUtils.join((String[])new String[]{requestUrl.toString(), "processedtemplates"}));
        return requestUrl;
    }
}

