/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.OperationInfo;
import io.fabric8.kubernetes.client.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.internal.LogWatchCallback;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.DoneableBuild;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.BuildResource;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class BuildOperationsImpl
extends OpenShiftOperation<Build, BuildList, DoneableBuild, BuildResource<Build, DoneableBuild, String, LogWatch>>
implements BuildResource<Build, DoneableBuild, String, LogWatch> {
    private final InputStream in;
    private final OutputStream out;
    private final OutputStream err;
    private final PipedOutputStream inPipe;
    private final PipedInputStream outPipe;
    private final PipedInputStream errPipe;
    private final boolean withTTY;
    private final boolean withTerminatedStatus;
    private final boolean withTimestamps;
    private final String sinceTimestamp;
    private final Integer sinceSeconds;
    private final Integer withTailingLines;
    private final boolean withPrettyOutput;
    private final String version;
    private final Integer limitBytes;

    public BuildOperationsImpl(OkHttpClient client, OpenShiftConfig config, String namespace) {
        this(client, config, null, namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, false, false, false, null, null, null, false, null, null);
    }

    public BuildOperationsImpl(OkHttpClient client, OpenShiftConfig config, String apiVersion, String namespace, String name, Boolean cascading, Build item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        this(client, config, null, namespace, name, cascading, item, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), null, null, null, null, null, null, false, false, false, null, null, null, false, null, null);
    }

    public BuildOperationsImpl(OkHttpClient client, OpenShiftConfig config, String apiVersion, String namespace, String name, Boolean cascading, Build item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, InputStream in, OutputStream out, OutputStream err, PipedOutputStream inPipe, PipedInputStream outPipe, PipedInputStream errPipe, boolean withTTY, boolean withTerminatedStatus, boolean withTimestamps, String sinceTimestamp, Integer sinceSeconds, Integer withTailingLines, boolean withPrettyOutput, String version, Integer limitBytes) {
        super(client, OpenShiftOperation.withApiGroup(client, "build.openshift.io", apiVersion, config), "builds", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.in = in;
        this.out = out;
        this.err = err;
        this.inPipe = inPipe;
        this.outPipe = outPipe;
        this.errPipe = errPipe;
        this.withTTY = withTTY;
        this.withTerminatedStatus = withTerminatedStatus;
        this.withTimestamps = withTimestamps;
        this.sinceTimestamp = sinceTimestamp;
        this.sinceSeconds = sinceSeconds;
        this.withTailingLines = withTailingLines;
        this.withPrettyOutput = withPrettyOutput;
        this.version = version;
        this.limitBytes = limitBytes;
    }

    protected String getLogParameters() {
        StringBuilder sb = new StringBuilder();
        sb.append("log?pretty=").append(this.withPrettyOutput);
        if (this.version != null && !this.version.isEmpty()) {
            sb.append("&version=").append(this.version);
        }
        if (this.withTerminatedStatus) {
            sb.append("&previous=true");
        }
        if (this.sinceSeconds != null) {
            sb.append("&sinceSeconds=").append(this.sinceSeconds);
        } else if (this.sinceTimestamp != null) {
            sb.append("&sinceTime=").append(this.sinceTimestamp);
        }
        if (this.withTailingLines != null) {
            sb.append("&tailLines=").append(this.withTailingLines);
        }
        if (this.limitBytes != null) {
            sb.append("&limitBytes=").append(this.limitBytes);
        }
        return sb.toString();
    }

    protected ResponseBody doGetLog() {
        try {
            URL url = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), this.getLogParameters()}));
            Request.Builder requestBuilder = new Request.Builder().get().url(url);
            Request request = requestBuilder.build();
            Response response = this.client.newCall(request).execute();
            ResponseBody body = response.body();
            this.assertResponseCode(request, response);
            return body;
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("doGetLog"), (Throwable)t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLog() {
        try (ResponseBody body = this.doGetLog();){
            String string = this.doGetLog().string();
            return string;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("getLog"), (Throwable)e);
        }
    }

    public String getLog(Boolean isPretty) {
        return new BuildOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Build)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, this.withTailingLines, this.withPrettyOutput, this.version, this.limitBytes).getLog();
    }

    public Reader getLogReader() {
        return this.doGetLog().charStream();
    }

    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    public LogWatch watchLog(OutputStream out) {
        try {
            URL url = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), this.getLogParameters() + "&follow=true"}));
            Request request = new Request.Builder().url(url).get().build();
            LogWatchCallback callback = new LogWatchCallback(out);
            OkHttpClient clone = this.client.newBuilder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
            clone.newCall(request).enqueue((Callback)callback);
            callback.waitUntilReady();
            return callback;
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("watchLog"), (Throwable)t);
        }
    }

    public Loggable<String, LogWatch> withPrettyOutput() {
        return new BuildOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Build)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, this.withTailingLines, true, this.version, this.limitBytes);
    }

    public PrettyLoggable<String, LogWatch> tailingLines(int withTailingLines) {
        return new BuildOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Build)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, withTailingLines, this.withPrettyOutput, this.version, this.limitBytes);
    }

    public TimeTailPrettyLoggable<String, LogWatch> terminated() {
        return new BuildOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Build)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, this.withTailingLines, this.withPrettyOutput, this.version, this.limitBytes);
    }

    public TailPrettyLoggable<String, LogWatch> sinceTime(String sinceTimestamp) {
        return new BuildOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Build)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, sinceTimestamp, this.sinceSeconds, this.withTailingLines, this.withPrettyOutput, this.version, this.limitBytes);
    }

    public TailPrettyLoggable<String, LogWatch> sinceSeconds(int sinceSeconds) {
        return new BuildOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Build)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, sinceSeconds, this.withTailingLines, this.withPrettyOutput, this.version, this.limitBytes);
    }

    public BytesLimitTerminateTimeTailPrettyLoggable<String, LogWatch> limitBytes(int limitBytes) {
        return new BuildOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Build)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, this.withTailingLines, this.withPrettyOutput, this.version, limitBytes);
    }
}

