/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.schema.generator.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.schema.generator.schema.SchemaUtils;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class SchemaFlattener {
    private static final String PACKAGE_SEPARATOR_CHARACTER = ".";
    private static final String SEPARATOR_CHARACTER = "_";
    private static final Set<String> preservedNames = ConcurrentHashMap.newKeySet();
    private static final ObjectMapper structureMapper;

    private SchemaFlattener() {
    }

    public static void flatten(OpenAPI model) {
        SchemaFlattenerContext context = SchemaFlattenerContext.get(model);
        SchemaFlattener.flattenComponents(context);
        context.getComponents().getSchemas().putAll(context.componentsToAdd);
        SchemaFlattenerContext.clear(model);
    }

    private static void flattenComponents(SchemaFlattenerContext context) {
        for (String componentKey : context.getComponents().getSchemas().keySet()) {
            Schema componentSchema = (Schema)context.getComponents().getSchemas().get(componentKey);
            SchemaFlattener.flattenProperties(context, componentSchema, ComponentName.resolve(componentSchema, componentKey));
        }
    }

    private static void flattenProperties(SchemaFlattenerContext context, Schema<?> schema, ComponentName path) {
        if (schema.getProperties() == null || schema.getProperties().isEmpty()) {
            return;
        }
        HashMap propertiesToUpdate = new HashMap();
        for (String string : schema.getProperties().keySet()) {
            Schema additionalPropertiesSchema;
            Schema propertySchema = (Schema)schema.getProperties().get(string);
            ComponentName flatComponentName = path.inline(propertySchema, string);
            if (propertySchema instanceof ObjectSchema && propertySchema.getProperties() != null && !propertySchema.getProperties().isEmpty()) {
                ObjectSchema objectSchema = (ObjectSchema)propertySchema;
                SchemaFlattener.flattenProperties(context, objectSchema, flatComponentName);
                propertiesToUpdate.put(string, context.toRef((Schema<?>)objectSchema, flatComponentName));
                continue;
            }
            if (SchemaUtils.isArray(propertySchema)) {
                Schema arrayItemsSchema = propertySchema.getItems();
                if (!(arrayItemsSchema instanceof ObjectSchema) || arrayItemsSchema.getProperties() == null || arrayItemsSchema.getProperties().isEmpty()) continue;
                SchemaFlattener.flattenProperties(context, arrayItemsSchema, flatComponentName);
                propertySchema.setItems(context.toRef(arrayItemsSchema, flatComponentName));
                continue;
            }
            if (!SchemaUtils.isMap(propertySchema) || !(propertySchema.getAdditionalProperties() instanceof Schema) || !((additionalPropertiesSchema = (Schema)propertySchema.getAdditionalProperties()) instanceof ObjectSchema) || additionalPropertiesSchema.getProperties() == null || additionalPropertiesSchema.getProperties().isEmpty()) continue;
            SchemaFlattener.flattenProperties(context, additionalPropertiesSchema, flatComponentName);
            propertySchema.setAdditionalProperties(context.toRef(additionalPropertiesSchema, flatComponentName));
        }
        for (Map.Entry entry : propertiesToUpdate.entrySet()) {
            schema.getProperties().put((String)entry.getKey(), (Schema)entry.getValue());
        }
    }

    private static String contract(String word) {
        StringBuilder sb = new StringBuilder();
        sb.append(word.substring(0, 1).toUpperCase());
        boolean inWord = true;
        for (int i = 1; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (!inWord && Character.isUpperCase(c)) {
                sb.append(c);
                inWord = true;
                continue;
            }
            if (!inWord || !Character.isLowerCase(c)) continue;
            inWord = false;
        }
        return sb.toString();
    }

    static {
        preservedNames.add("spec");
        preservedNames.add("status");
        preservedNames.add("aws");
        preservedNames.add("azure");
        preservedNames.add("baremetal");
        preservedNames.add("gcp");
        preservedNames.add("ibmcloud");
        preservedNames.add("libvirt");
        preservedNames.add("nutanix");
        preservedNames.add("none");
        preservedNames.add("openstack");
        preservedNames.add("ovirt");
        preservedNames.add("powervs");
        preservedNames.add("vsphere");
        preservedNames.add("basicAuth");
        preservedNames.add("openID");
        structureMapper = Json.mapper().copy();
        structureMapper.getSerializationConfig().with(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});
        structureMapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
    }

    private static final class ComponentName {
        private final String pkg;
        private final List<String> nameParts;

        static ComponentName resolve(Schema<?> schema, String key) {
            ComponentName componentName = schema.getTitle() != null && !schema.getTitle().isEmpty() ? new ComponentName(schema.getTitle()) : new ComponentName(key);
            return componentName;
        }

        private ComponentName(String name) {
            String simpleClassName;
            if (name.contains(SchemaFlattener.PACKAGE_SEPARATOR_CHARACTER)) {
                this.pkg = name.substring(0, name.lastIndexOf(SchemaFlattener.PACKAGE_SEPARATOR_CHARACTER));
                simpleClassName = name.substring(name.lastIndexOf(SchemaFlattener.PACKAGE_SEPARATOR_CHARACTER) + 1);
            } else {
                this.pkg = "";
                simpleClassName = name;
            }
            this.nameParts = Arrays.stream(simpleClassName.split(SchemaFlattener.SEPARATOR_CHARACTER, 0)).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }

        private ComponentName(String pkg, List<String> nameParts) {
            this.pkg = pkg;
            this.nameParts = nameParts;
        }

        ComponentName inline(Schema<?> schema, String path) {
            if (schema.getTitle() != null && !schema.getTitle().isEmpty()) {
                return new ComponentName(schema.getTitle());
            }
            if (path.isEmpty()) {
                throw new IllegalArgumentException("Path cannot be empty");
            }
            ComponentName inline = new ComponentName(this.pkg, new ArrayList<String>(this.nameParts));
            inline.nameParts.add(path);
            return inline;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (!this.pkg.isEmpty()) {
                sb.append(this.pkg).append(SchemaFlattener.PACKAGE_SEPARATOR_CHARACTER);
            }
            sb.append(this.nameParts.get(0));
            for (int it = 1; it < this.nameParts.size() - 1; ++it) {
                String part = this.nameParts.get(it);
                if (preservedNames.contains(part)) {
                    sb.append(part.substring(0, 1).toUpperCase()).append(part.substring(1));
                    continue;
                }
                sb.append(SchemaFlattener.contract(part));
            }
            if (this.nameParts.size() > 1) {
                String lastPart = this.nameParts.get(this.nameParts.size() - 1);
                sb.append(lastPart.substring(0, 1).toUpperCase());
                sb.append(lastPart.substring(1));
            }
            return sb.toString();
        }
    }

    private static final class SchemaFlattenerContext {
        private static final String CONTEXT_KEY = SchemaFlattenerContext.class.getName();
        private final OpenAPI openAPI;
        private final Set<String> uniqueNames;
        private final Map<String, String> reusableComponentSignatures;
        private final Map<String, Schema<?>> componentsToAdd;

        private static synchronized SchemaFlattenerContext get(OpenAPI openAPI) {
            if (openAPI.getExtensions() == null) {
                openAPI.setExtensions(new HashMap());
            }
            return (SchemaFlattenerContext)openAPI.getExtensions().computeIfAbsent(CONTEXT_KEY, k -> new SchemaFlattenerContext(openAPI));
        }

        private static synchronized void clear(OpenAPI openAPI) {
            if (openAPI.getExtensions() != null) {
                openAPI.getExtensions().remove(CONTEXT_KEY);
            }
        }

        public SchemaFlattenerContext(OpenAPI openAPI) {
            this.openAPI = openAPI;
            if (openAPI.getComponents() == null) {
                openAPI.setComponents(new Components());
            }
            if (openAPI.getComponents().getSchemas() == null) {
                openAPI.getComponents().setSchemas(new HashMap());
            }
            this.uniqueNames = ConcurrentHashMap.newKeySet();
            this.reusableComponentSignatures = new HashMap<String, String>();
            for (String key : openAPI.getComponents().getSchemas().keySet()) {
                this.reusableComponentSignatures.put(this.toJson((Schema)openAPI.getComponents().getSchemas().get(key)), key);
            }
            this.componentsToAdd = new ConcurrentHashMap();
        }

        Components getComponents() {
            return this.openAPI.getComponents();
        }

        void addComponentSchema(String key, Schema<?> componentSchema) {
            this.componentsToAdd.put(key, componentSchema);
        }

        Schema<?> toRef(Schema<?> schema, ComponentName componentName) {
            String existingModelName = this.reusableComponentSignatures.getOrDefault(this.toJson(schema), null);
            Schema refSchema = new Schema();
            refSchema.setRequired(schema.getRequired());
            if (existingModelName != null) {
                refSchema.$ref(existingModelName);
            } else {
                String uniqueName = this.uniqueName(componentName.toString());
                refSchema.$ref(uniqueName);
                this.addComponentSchema(uniqueName, schema);
            }
            return refSchema;
        }

        private String toJson(Schema<?> schema) {
            try {
                return structureMapper.writeValueAsString(schema);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Error serializing schema to JSON", e);
            }
        }

        private String uniqueName(String name) {
            Object uniqueName = name;
            int count = 0;
            while (true) {
                if (!this.uniqueNames.contains(uniqueName) && !this.getComponents().getSchemas().containsKey(uniqueName)) {
                    this.uniqueNames.add((String)uniqueName);
                    return uniqueName;
                }
                uniqueName = name + SchemaFlattener.SEPARATOR_CHARACTER + ++count;
            }
        }
    }
}

