/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.vertx;

import io.vertx.core.http.HttpVersion;
import java.util.Locale;

public enum Protocol {
    HTTP_1_0(HttpVersion.HTTP_1_0, "http/1.0"),
    HTTP_1_1(HttpVersion.HTTP_1_1, "http/1.1"),
    HTTP_2(HttpVersion.HTTP_2, "h2", "h2_prior_knowledge", "h2c", "http/2", "http/2.0");

    private final String[] protocolNames;
    private final HttpVersion httpVersion;

    private Protocol(HttpVersion httpVersion, String ... protocolNames) {
        this.httpVersion = httpVersion;
        this.protocolNames = protocolNames;
    }

    public static Protocol get(String protocol) {
        for (Protocol p : Protocol.values()) {
            for (String protocolName : p.protocolNames) {
                if (!protocolName.equals(protocol.toLowerCase(Locale.ROOT))) continue;
                return p;
            }
        }
        throw new IllegalArgumentException("Unknown protocol: " + protocol);
    }

    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    public String toString() {
        return this.protocolNames[0];
    }
}

