/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.http;

import io.fabric8.mockwebserver.http.Buffer;
import io.fabric8.mockwebserver.http.Headers;
import io.fabric8.mockwebserver.http.Response;
import io.fabric8.mockwebserver.http.WebSocketListener;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class MockResponse
implements Response {
    private Headers.Builder headers = Headers.builder();
    private String httpVersion = "HTTP/1.1";
    private int code;
    private Buffer body;
    private Duration bodyDelay;
    private WebSocketListener webSocketListener;

    @Override
    public String getStatus() {
        String reason;
        HttpResponseStatus status = this.code == 200 || this.code % 100 != 0 ? HttpResponseStatus.valueOf((int)this.code) : HttpResponseStatus.valueOf((int)(this.code + 99));
        String string = reason = status.codeClass() == HttpStatusClass.UNKNOWN ? "Mock Response" : status.reasonPhrase();
        if (reason.indexOf(40) > -1) {
            reason = reason.substring(0, reason.indexOf(40));
        }
        return this.httpVersion + " " + this.code + " " + reason.trim();
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public Headers getHeaders() {
        return this.headers.build();
    }

    @Override
    public Buffer getBody() {
        return this.body;
    }

    @Override
    public WebSocketListener getWebSocketListener() {
        return this.webSocketListener;
    }

    public List<String> headers(String key) {
        return this.headers.build().headers(key);
    }

    public String header(String key) {
        return this.headers.build().header(key);
    }

    public MockResponse setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
        return this;
    }

    public MockResponse setResponseCode(int code) {
        this.code = code;
        return this;
    }

    public MockResponse setBody(Buffer body) {
        this.body = body;
        return this;
    }

    public MockResponse setBody(byte[] body) {
        return this.setBody(new Buffer(body));
    }

    public MockResponse setBody(String body) {
        return this.setBody(new Buffer().writeUtf8(body));
    }

    public MockResponse setChunkedBody(Buffer body, int maxChunkSize) {
        int chunkSize;
        this.removeHeader("Content-Length");
        this.setHeader("Transfer-encoding", "chunked");
        Buffer chunkedBody = new Buffer();
        byte[] bodyBytes = body.getBytes();
        for (int offset = 0; offset < bodyBytes.length; offset += chunkSize) {
            chunkSize = Math.min(bodyBytes.length - offset, maxChunkSize);
            chunkedBody.writeUtf8(Integer.toHexString(chunkSize));
            chunkedBody.writeUtf8("\r\n");
            chunkedBody.write(bodyBytes, offset, chunkSize);
            chunkedBody.writeUtf8("\r\n");
        }
        chunkedBody.writeUtf8("0\r\n");
        this.body = chunkedBody;
        return this;
    }

    public MockResponse setChunkedBody(String body, int maxChunkSize) {
        return this.setChunkedBody(new Buffer().writeUtf8(body), maxChunkSize);
    }

    public Duration getBodyDelay() {
        return this.bodyDelay;
    }

    public MockResponse setBodyDelay(long delay, TimeUnit delayUnit) {
        return this.setBodyDelay(Duration.ofMillis(delayUnit.toMillis(delay)));
    }

    public MockResponse setBodyDelay(Duration bodyDelay) {
        this.bodyDelay = bodyDelay;
        return this;
    }

    public MockResponse clearHeaders() {
        this.headers = Headers.builder();
        return this;
    }

    public MockResponse addHeader(String header) {
        this.headers.add(header);
        return this;
    }

    public MockResponse addHeader(String name, Object value) {
        this.headers.add(name, String.valueOf(value));
        return this;
    }

    public MockResponse setHeaders(Headers headers) {
        this.headers = headers.newBuilder();
        return this;
    }

    public MockResponse setHeader(String name, Object value) {
        this.headers.setHeader(name, String.valueOf(value));
        return this;
    }

    public MockResponse removeHeader(String name) {
        this.headers.removeAll(name);
        return this;
    }

    public MockResponse withWebSocketUpgrade(WebSocketListener listener) {
        this.body = null;
        this.webSocketListener = listener;
        return this;
    }

    public String toString() {
        return this.getStatus();
    }
}

