/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.vertx;

import io.fabric8.mockwebserver.dsl.HttpMethod;
import io.fabric8.mockwebserver.http.Headers;
import io.fabric8.mockwebserver.http.MockResponse;
import io.fabric8.mockwebserver.http.RecordedRequest;
import io.fabric8.mockwebserver.vertx.ServerWebSocketHandler;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.util.Locale;
import java.util.Map;

public abstract class HttpServerRequestHandler
implements Handler<HttpServerRequest> {
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String CONTENT_TYPE = "Content-Type";
    private final Vertx vertx;

    protected HttpServerRequestHandler(Vertx vertx) {
        this.vertx = vertx;
    }

    protected abstract MockResponse onHttpRequest(RecordedRequest var1);

    public final void handle(HttpServerRequest event) {
        Handler exceptionHandler = err -> {
            if (!event.response().headWritten()) {
                event.response().setStatusCode(500).setStatusMessage(err.getMessage()).send();
            }
        };
        event.resume();
        Future body = HttpServerRequestHandler.hasBody(event) ? event.body() : Future.succeededFuture(null);
        body.onFailure(exceptionHandler);
        body.onSuccess(bodyBuffer -> {
            RecordedRequest request = new RecordedRequest(event.version().alpnName().toUpperCase(Locale.ROOT), HttpMethod.fromVertx(event.method()), event.uri(), Headers.builder().addAll((Iterable<Map.Entry<String, String>>)event.headers()).build(), new io.fabric8.mockwebserver.http.Buffer(bodyBuffer == null ? null : bodyBuffer.getBytes()));
            MockResponse mockResponse = this.onHttpRequest(request);
            if (mockResponse.getWebSocketListener() != null) {
                event.toWebSocket().onFailure(exceptionHandler).onSuccess((Handler)new ServerWebSocketHandler(request, mockResponse));
                return;
            }
            HttpServerResponse vertxResponse = event.response();
            vertxResponse.setStatusCode(mockResponse.code());
            mockResponse.getHeaders().toMultimap().forEach((key, values) -> vertxResponse.headers().add(key, (Iterable)values));
            if (mockResponse.getBody() != null && mockResponse.getBody().size() > 0L) {
                vertxResponse.headers().add(CONTENT_LENGTH, String.valueOf(mockResponse.getBody().size()));
                Buffer toSend = Buffer.buffer((byte[])mockResponse.getBody().getBytes());
                if (mockResponse.getBodyDelay() != null) {
                    this.vertx.setTimer(mockResponse.getBodyDelay().toMillis(), timerId -> vertxResponse.send(toSend));
                } else {
                    vertxResponse.send(toSend);
                }
            } else {
                vertxResponse.end();
            }
        });
    }

    private static boolean hasBody(HttpServerRequest event) {
        String contentLength = event.headers().get(CONTENT_LENGTH);
        if (contentLength != null && !contentLength.trim().isEmpty() && Integer.parseInt(contentLength) > 0) {
            return true;
        }
        return event.headers().contains(CONTENT_TYPE);
    }
}

