/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.internal;

import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.http.Dispatcher;
import io.fabric8.mockwebserver.http.MockResponse;
import io.fabric8.mockwebserver.http.RecordedRequest;
import io.fabric8.mockwebserver.internal.SimpleRequest;
import io.fabric8.mockwebserver.internal.SimpleResponse;
import io.fabric8.mockwebserver.internal.WebSocketSession;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MockDispatcher
extends Dispatcher {
    private final Map<ServerRequest, Queue<ServerResponse>> responses;
    private final Collection<WebSocketSession> webSocketSessions = new ConcurrentLinkedQueue<WebSocketSession>();

    public MockDispatcher(Map<ServerRequest, Queue<ServerResponse>> responses) {
        this.responses = responses;
    }

    @Override
    public MockResponse dispatch(RecordedRequest request) {
        for (WebSocketSession webSocketSession : this.webSocketSessions) {
            webSocketSession.dispatch(request);
        }
        String path = request.getPath();
        SimpleRequest key = new SimpleRequest(request.method(), path);
        SimpleRequest keyForAnyMethod = new SimpleRequest(path);
        if (this.responses.containsKey(key)) {
            Queue<ServerResponse> queue = this.responses.get(key);
            return this.handleResponse(queue.peek(), queue, request);
        }
        if (this.responses.containsKey(keyForAnyMethod)) {
            Queue<ServerResponse> queue = this.responses.get(keyForAnyMethod);
            return this.handleResponse(queue.peek(), queue, request);
        }
        return new MockResponse().setHttpVersion(request.getHttpVersion()).setResponseCode(404);
    }

    private MockResponse handleResponse(ServerResponse response, Queue<ServerResponse> queue, RecordedRequest request) {
        SimpleResponse simpleResponse;
        if (response == null) {
            return new MockResponse().setHttpVersion(request.getHttpVersion()).setResponseCode(404);
        }
        if (!response.isRepeatable()) {
            queue.remove();
        }
        if (response instanceof SimpleResponse && (simpleResponse = (SimpleResponse)response).getWebSocketSession() != null) {
            this.webSocketSessions.add(simpleResponse.getWebSocketSession());
        }
        return response.toMockResponse(request);
    }

    @Override
    public void shutdown() {
        this.webSocketSessions.forEach(WebSocketSession::shutdown);
        super.shutdown();
    }
}

