/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.crud;

import io.fabric8.mockwebserver.crud.AttributeType;
import io.fabric8.mockwebserver.crud.Key;
import io.fabric8.mockwebserver.crud.Value;
import java.util.Objects;

public class Attribute {
    private final Key key;
    private final Value value;
    private final AttributeType type;

    public Attribute(Key key, Value value, AttributeType type) {
        this.key = key;
        this.value = value;
        this.type = type;
    }

    public Attribute(String key, String value, AttributeType type) {
        this(new Key(key), new Value(value), type);
    }

    public Attribute(Key key, Value value) {
        this(key, value, AttributeType.WITH);
    }

    public Attribute(String key, String value) {
        this(new Key(key), new Value(value));
    }

    public Key getKey() {
        return this.key;
    }

    public Value getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return Objects.equals(this.key, attribute.key) && Objects.equals(this.value, attribute.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return "{key:" + this.key + ", value:" + this.value + '}';
    }

    public AttributeType getType() {
        return this.type;
    }
}

