/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.crud;

import io.fabric8.mockwebserver.crud.Attribute;
import io.fabric8.mockwebserver.crud.AttributeType;
import io.fabric8.mockwebserver.crud.Key;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AttributeSet {
    private final Map<Key, Attribute> attributes;

    public static AttributeSet merge(AttributeSet ... attributeSets) {
        HashMap<Key, Attribute> all = new HashMap<Key, Attribute>();
        if (attributeSets != null) {
            for (AttributeSet f : attributeSets) {
                if (f == null || f.attributes == null) continue;
                all.putAll(f.attributes);
            }
        }
        return new AttributeSet(all);
    }

    public static AttributeSet map(Attribute ... attributes) {
        HashMap<Key, Attribute> all = new HashMap<Key, Attribute>();
        if (attributes != null) {
            for (Attribute a : attributes) {
                all.put(a.getKey(), a);
            }
        }
        return new AttributeSet(all);
    }

    public AttributeSet(Attribute ... attributes) {
        this(Arrays.asList(attributes));
    }

    public AttributeSet(Collection<Attribute> attributes) {
        this(AttributeSet.map((Attribute[])attributes.toArray(new Attribute[attributes.size()])).attributes);
    }

    public AttributeSet(Map<Key, Attribute> attributes) {
        this.attributes = attributes;
    }

    public AttributeSet add(Attribute ... attr) {
        HashMap<Key, Attribute> all = new HashMap<Key, Attribute>(this.attributes);
        for (Attribute a : attr) {
            all.put(a.getKey(), a);
        }
        return new AttributeSet(all);
    }

    public boolean containsKey(String key) {
        return this.containsKey(new Key(key));
    }

    public boolean containsKey(Key key) {
        return this.attributes.containsKey(key);
    }

    public boolean matches(AttributeSet candidate) {
        for (Attribute c : candidate.attributes.values()) {
            if (c.getType().equals((Object)AttributeType.WITHOUT)) {
                return !this.attributes.values().contains(c);
            }
            if (this.attributes.values().contains(c)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeSet that = (AttributeSet)o;
        return this.attributes != null ? this.attributes.equals(that.attributes) : that.attributes == null;
    }

    public int hashCode() {
        return this.attributes != null ? this.attributes.hashCode() : 0;
    }

    public String toString() {
        return "{attributes: " + this.attributes + '}';
    }
}

