/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.internal;

import io.fabric8.mockwebserver.ServerResponse;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.mockwebserver.MockResponse;

public class ChunkedResponse
implements ServerResponse {
    private static final int DEFAULT_MAX_CHUNK_SIZE = 204800;
    private final int statusCode;
    private final List<String> body;
    private final boolean repeatable;
    private final long responseDelay;
    private final TimeUnit responseDelayUnit;

    public ChunkedResponse(boolean repeatable, int statusCode, String ... body) {
        this(repeatable, statusCode, 0L, TimeUnit.MILLISECONDS, body);
    }

    public ChunkedResponse(boolean repeatable, int statusCode, long responseDelay, TimeUnit responseDelayUnit, String ... body) {
        this.statusCode = statusCode;
        this.body = Arrays.asList(body);
        this.repeatable = repeatable;
        this.responseDelay = responseDelay;
        this.responseDelayUnit = responseDelayUnit;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public List<String> getBody() {
        return this.body;
    }

    @Override
    public MockResponse toMockResponse() {
        MockResponse mockResponse = new MockResponse();
        mockResponse.setChunkedBody(this.concatBody(), 204800);
        mockResponse.setResponseCode(this.statusCode);
        if (this.responseDelay > 0L) {
            mockResponse.setBodyDelay(this.responseDelay, this.responseDelayUnit);
        }
        return mockResponse;
    }

    private String concatBody() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.body) {
            sb.append(s);
        }
        return sb.toString();
    }

    @Override
    public boolean isRepeatable() {
        return this.repeatable;
    }
}

