/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.Function;
import io.fabric8.mockwebserver.dsl.HttpMethod;
import io.fabric8.mockwebserver.dsl.MockServerExpectation;
import io.fabric8.mockwebserver.dsl.Pathable;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOrOnceable;
import io.fabric8.mockwebserver.dsl.WebSocketSessionBuilder;
import io.fabric8.mockwebserver.internal.ChunkedResponse;
import io.fabric8.mockwebserver.internal.InlineWebSocketSessionBuilder;
import io.fabric8.mockwebserver.internal.SimpleRequest;
import io.fabric8.mockwebserver.internal.SimpleResponse;
import io.fabric8.mockwebserver.internal.WebSocketSession;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

public class MockServerExpectationImpl
implements MockServerExpectation {
    private final Context context;
    private final HttpMethod method;
    private final String path;
    private final int statusCode;
    private final String body;
    private final String[] chunks;
    private final long initialDelay;
    private final long period;
    private final TimeUnit timeUnit;
    private final int times;
    private final Map<ServerRequest, Queue<ServerResponse>> responses;

    public MockServerExpectationImpl(Map<ServerRequest, Queue<ServerResponse>> responses, Context context) {
        this(context, HttpMethod.ANY, null, 200, null, null, 0L, 0L, TimeUnit.SECONDS, 1, responses);
    }

    public MockServerExpectationImpl(Context context, HttpMethod method, String path, int statusCode, String body, String[] chunks, long initialDelay, long period, TimeUnit timeUnit, int times, Map<ServerRequest, Queue<ServerResponse>> responses) {
        this.context = context;
        this.method = method;
        this.path = path;
        this.statusCode = statusCode;
        this.body = body;
        this.chunks = chunks;
        this.initialDelay = initialDelay;
        this.period = period;
        this.timeUnit = timeUnit;
        this.times = times;
        this.responses = responses;
    }

    @Override
    public Pathable<ReturnOrWebsocketable<TimesOrOnceable<Void>>> any() {
        return new MockServerExpectationImpl(this.context, HttpMethod.ANY, this.path, this.statusCode, this.body, this.chunks, this.initialDelay, this.period, this.timeUnit, this.times, this.responses);
    }

    @Override
    public Pathable<ReturnOrWebsocketable<TimesOrOnceable<Void>>> post() {
        return new MockServerExpectationImpl(this.context, HttpMethod.POST, this.path, this.statusCode, this.body, this.chunks, this.initialDelay, this.period, this.timeUnit, this.times, this.responses);
    }

    @Override
    public Pathable<ReturnOrWebsocketable<TimesOrOnceable<Void>>> get() {
        return new MockServerExpectationImpl(this.context, HttpMethod.GET, this.path, this.statusCode, this.body, this.chunks, this.initialDelay, this.period, this.timeUnit, this.times, this.responses);
    }

    @Override
    public Pathable<ReturnOrWebsocketable<TimesOrOnceable<Void>>> put() {
        return new MockServerExpectationImpl(this.context, HttpMethod.PUT, this.path, this.statusCode, this.body, this.chunks, this.initialDelay, this.period, this.timeUnit, this.times, this.responses);
    }

    @Override
    public Pathable<ReturnOrWebsocketable<TimesOrOnceable<Void>>> delete() {
        return new MockServerExpectationImpl(this.context, HttpMethod.DELETE, this.path, this.statusCode, this.body, this.chunks, this.initialDelay, this.period, this.timeUnit, this.times, this.responses);
    }

    @Override
    public ReturnOrWebsocketable<TimesOrOnceable<Void>> withPath(String path) {
        return new MockServerExpectationImpl(this.context, this.method, path, this.statusCode, this.body, this.chunks, this.initialDelay, this.period, this.timeUnit, this.times, this.responses);
    }

    @Override
    public TimesOrOnceable<Void> andReturn(int statusCode, Object content) {
        return new MockServerExpectationImpl(this.context, this.method, this.path, statusCode, this.toString(content), this.chunks, this.initialDelay, this.period, this.timeUnit, this.times, this.responses);
    }

    @Override
    public TimesOrOnceable<Void> andReturnChucked(int statusCode, Object ... contents) {
        return new MockServerExpectationImpl(this.context, this.method, this.path, statusCode, this.body, this.toString(contents), this.initialDelay, this.period, this.timeUnit, this.times, this.responses);
    }

    @Override
    public Void always() {
        this.enqueue(new SimpleRequest(this.method, this.path), this.createResponse(true));
        return null;
    }

    @Override
    public Void once() {
        this.enqueue(new SimpleRequest(this.method, this.path), this.createResponse(false));
        return null;
    }

    @Override
    public Void times(int times) {
        for (int i = 0; i < times; ++i) {
            this.once();
        }
        return null;
    }

    @Override
    public WebSocketSessionBuilder<TimesOrOnceable<Void>> andUpgradeToWebSocket() {
        return new InlineWebSocketSessionBuilder<TimesOrOnceable<Void>>(this.context, new Function<WebSocketSession, TimesOrOnceable<Void>>(){

            @Override
            public TimesOrOnceable<Void> apply(final WebSocketSession webSocketSession) {
                return new TimesOrOnceable<Void>(){

                    @Override
                    public Void always() {
                        MockServerExpectationImpl.this.enqueue(new SimpleRequest(MockServerExpectationImpl.this.method, MockServerExpectationImpl.this.path), new SimpleResponse(true, MockServerExpectationImpl.this.statusCode, null, webSocketSession));
                        return null;
                    }

                    @Override
                    public Void once() {
                        MockServerExpectationImpl.this.enqueue(new SimpleRequest(MockServerExpectationImpl.this.method, MockServerExpectationImpl.this.path), new SimpleResponse(false, MockServerExpectationImpl.this.statusCode, null, webSocketSession));
                        return null;
                    }

                    @Override
                    public Void times(int times) {
                        for (int i = 0; i < times; ++i) {
                            this.once();
                        }
                        return null;
                    }
                };
            }
        });
    }

    private void enqueue(ServerRequest req, ServerResponse resp) {
        Queue<ServerResponse> queuedResponses = this.responses.get(req);
        if (queuedResponses == null) {
            queuedResponses = new ArrayDeque<ServerResponse>();
            this.responses.put(req, queuedResponses);
        }
        queuedResponses.add(resp);
    }

    private ServerResponse createResponse(boolean repeatable) {
        if (this.chunks != null) {
            return new ChunkedResponse(repeatable, this.statusCode, this.chunks);
        }
        return new SimpleResponse(repeatable, this.statusCode, this.body, null);
    }

    private String toString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        try {
            return this.context.getMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private String[] toString(Object[] object) {
        String[] strings = new String[object.length];
        for (int i = 0; i < object.length; ++i) {
            strings[i] = this.toString(object[i]);
        }
        return strings;
    }
}

