/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver;

import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.MockServerExpectation;
import io.fabric8.mockwebserver.internal.MockDispatcher;
import io.fabric8.mockwebserver.internal.MockSSLContextFactory;
import io.fabric8.mockwebserver.internal.MockServerExpectationImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;

public class DefaultMockServer {
    private final Context context;
    private final boolean useHttps;
    private final MockWebServer server;
    private final Map<ServerRequest, Queue<ServerResponse>> responses;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final AtomicBoolean shutdown = new AtomicBoolean();

    public DefaultMockServer() {
        this(new Context(), new MockWebServer(), new HashMap<ServerRequest, Queue<ServerResponse>>(), false);
    }

    public DefaultMockServer(boolean useHttps) {
        this(new Context(), new MockWebServer(), new HashMap<ServerRequest, Queue<ServerResponse>>(), useHttps);
    }

    public DefaultMockServer(MockWebServer server, Map<ServerRequest, Queue<ServerResponse>> responses, boolean useHttps) {
        this(new Context(), server, responses, useHttps);
    }

    public DefaultMockServer(Context context, MockWebServer server, Map<ServerRequest, Queue<ServerResponse>> responses, boolean useHttps) {
        this.context = context;
        this.useHttps = useHttps;
        this.server = server;
        this.responses = responses;
        this.server.setDispatcher((Dispatcher)new MockDispatcher(responses));
    }

    public void onStart() {
    }

    public void onShutdown() {
    }

    private void startInternal() {
        if (this.initialized.compareAndSet(false, true)) {
            if (this.useHttps) {
                this.server.useHttps(MockSSLContextFactory.create().getSocketFactory(), false);
            }
            this.onStart();
        }
    }

    private void shutdownInternal() {
        if (this.shutdown.compareAndSet(false, true)) {
            this.onShutdown();
        }
    }

    public void start() {
        try {
            this.startInternal();
            this.server.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void start(int port) {
        try {
            this.startInternal();
            this.server.start(port);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void start(InetAddress inetAddress, int port) {
        try {
            this.startInternal();
            this.server.start(inetAddress, port);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        try {
            this.server.shutdown();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.shutdownInternal();
        }
    }

    public String url(String path) {
        return this.server.url(path).toString();
    }

    public int getPort() {
        return this.server.getPort();
    }

    public String getHostName() {
        return this.server.getHostName();
    }

    public Proxy toProxyAddress() {
        return this.server.toProxyAddress();
    }

    public int getRequestCount() {
        return this.server.getRequestCount();
    }

    @Deprecated
    public MockWebServer getServer() {
        return this.server;
    }

    public MockServerExpectation expect() {
        return new MockServerExpectationImpl(this.responses, this.context);
    }
}

