/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.internal;

import com.squareup.okhttp.mockwebserver.Dispatcher;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.HttpMethod;
import io.fabric8.mockwebserver.internal.SimpleRequest;
import java.util.Map;
import java.util.Queue;

public class MockDispatcher
extends Dispatcher {
    private final Map<ServerRequest, Queue<ServerResponse>> responses;

    public MockDispatcher(Map<ServerRequest, Queue<ServerResponse>> responses) {
        this.responses = responses;
    }

    public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
        HttpMethod method = HttpMethod.valueOf(request.getMethod());
        String path = request.getPath();
        SimpleRequest key = new SimpleRequest(method, path);
        SimpleRequest keyForAnyMethod = new SimpleRequest(path);
        if (this.responses.containsKey(key)) {
            Queue<ServerResponse> queue = this.responses.get(key);
            return this.handleResponse(queue.peek(), queue);
        }
        if (this.responses.containsKey(keyForAnyMethod)) {
            Queue<ServerResponse> queue = this.responses.get(keyForAnyMethod);
            return this.handleResponse(queue.peek(), queue);
        }
        return new MockResponse().setResponseCode(404);
    }

    private MockResponse handleResponse(ServerResponse response, Queue<ServerResponse> queue) {
        if (response == null) {
            return new MockResponse().setResponseCode(404);
        }
        if (!response.isRepeatable()) {
            queue.remove();
        }
        return response.toMockResponse();
    }
}

