/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.letschat;

import io.fabric8.letschat.LetsChatClientSupport;
import io.fabric8.utils.Strings;
import io.fabric8.utils.cxf.WebClients;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.bind.DatatypeConverter;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;

public class LetsChatClient
extends LetsChatClientSupport {
    public LetsChatClient(String address, String username, String password, String authToken) {
        super(address, username, password, authToken);
    }

    @Override
    protected <T> T createWebClient(Class<T> clientType) {
        List providers = WebClients.createProviders();
        providers.add(new Authenticator());
        WebClient webClient = WebClient.create((String)this.address, (List)providers);
        WebClients.disableSslChecks((WebClient)webClient);
        return (T)JAXRSClientFactory.fromClient((Client)webClient, clientType);
    }

    protected class Authenticator
    implements ClientRequestFilter {
        protected Authenticator() {
        }

        public void filter(ClientRequestContext requestContext) throws IOException {
            MultivaluedMap headers = requestContext.getHeaders();
            String authenticationHeader = this.getAuthenticationHeader();
            if (Strings.isNotBlank((String)authenticationHeader)) {
                headers.add((Object)"Authorization", (Object)authenticationHeader);
            }
        }

        private String getAuthenticationHeader() {
            String token = LetsChatClient.this.getAuthToken();
            if (Strings.isNotBlank((String)token)) {
                return "Bearer " + token;
            }
            String userPassword = LetsChatClient.this.getUsername() + ":" + LetsChatClient.this.getPassword();
            try {
                return "Basic " + DatatypeConverter.printBase64Binary((byte[])userPassword.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException("Cannot encode with UTF-8", ex);
            }
        }
    }
}

