/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.server.mock;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.server.mock.CustomResourceDefinitionProcessor;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.mockwebserver.crud.Attribute;
import io.fabric8.mockwebserver.crud.AttributeExtractor;
import io.fabric8.mockwebserver.crud.AttributeSet;
import io.fabric8.mockwebserver.crud.AttributeType;
import io.fabric8.mockwebserver.http.HttpUrl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesAttributesExtractor
implements AttributeExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesAttributesExtractor.class);
    public static final String KEY = "key";
    public static final String KIND = "kind";
    public static final String API = "api";
    public static final String VERSION = "version";
    public static final String NAME = "name";
    public static final String METADATA_NAME = "metadata.name";
    public static final String NAMESPACE = "namespace";
    public static final String METADATA_NAMESPACE = "metadata.namespace";
    public static final String VALUE = "value";
    public static final String PLURAL = "plural";
    public static final String UNKNOWN_KIND = "%unknown";
    private static final String API_GROUP = "/o?api(s/[a-zA-Z0-9-_.]+)?";
    private static final String VERSION_GROUP = "(/(?<version>[a-zA-Z0-9-_]+))?";
    private static final String KIND_GROUP = "/(?<kind>[^/?]+)";
    private static final String NAME_GROUP = "(/(?<name>[^/?]+))?";
    private static final String NAMESPACE_GROUP = "(/namespaces/(?<namespace>[^/]+))?";
    private static final String SUBRESOURCE_MAYBE_GROUP = "(/(status|scale))?";
    private static final String END_GROUP = "[^ /]*";
    protected static final Pattern PATTERN = Pattern.compile("/o?api(s/[a-zA-Z0-9-_.]+)?(/(?<version>[a-zA-Z0-9-_]+))?(/namespaces/(?<namespace>[^/]+))?/(?<kind>[^/?]+)(/(?<name>[^/?]+))?(/(status|scale))?[^ /]*");
    private static final String LABEL_KEY_PREFIX = "labels:";
    private static final String KEY_GROUP = "(?<key>[a-zA-Z0-9-_./]+)";
    private static final String EQUALITY_GROUP = "(==|(?<!!)=)";
    private static final String NOT_EQUALITY_GROUP = "(!=)";
    private static final String VALUE_GROUP = "(?<value>[a-zA-Z0-9-_.]+)";
    private static final Pattern LABEL_REQUIREMENT_EQUALITY = Pattern.compile("(?<key>[a-zA-Z0-9-_./]+)(==|(?<!!)=)(?<value>[a-zA-Z0-9-_.]+)");
    private static final Pattern LABEL_REQUIREMENT_NOT_EQUALITY = Pattern.compile("(?<key>[a-zA-Z0-9-_./]+)(!=)(?<value>[a-zA-Z0-9-_.]+)");
    private static final Pattern LABEL_REQUIREMENT_EXISTS = Pattern.compile("(?<key>[a-zA-Z0-9-_./]+)");
    private static final Pattern LABEL_REQUIREMENT_NOT_EXISTS = Pattern.compile("!(?<key>[a-zA-Z0-9-_./]+)");
    private static final String SCHEME = "http";
    private static final String HOST = "localhost";
    private CustomResourceDefinitionProcessor customResourceDefinitionProcessor;

    static List<String> pluralKey(String api, String version, String plural) {
        return Arrays.asList(api, version, plural);
    }

    public void setCustomResourceDefinitionProcessor(CustomResourceDefinitionProcessor customResourceDefinitionProcessor) {
        this.customResourceDefinitionProcessor = customResourceDefinitionProcessor;
    }

    private HttpUrl parseUrlFromPathAndQuery(String s) {
        if (!((String)s).startsWith("/")) {
            s = "/" + (String)s;
        }
        return HttpUrl.parse((String)String.format("%s://%s%s", SCHEME, HOST, s));
    }

    public Map<String, String> fromKubernetesPath(String s) {
        if (s == null || s.isEmpty()) {
            return Collections.emptyMap();
        }
        HttpUrl url = this.parseUrlFromPathAndQuery(s);
        Matcher m = PATTERN.matcher(url.encodedPath());
        if (m.matches()) {
            return this.extract(m);
        }
        return Collections.emptyMap();
    }

    public AttributeSet fromPath(String s) {
        if (s == null || s.isEmpty()) {
            return new AttributeSet(new Attribute[0]);
        }
        HttpUrl url = this.parseUrlFromPathAndQuery(s);
        Matcher m = PATTERN.matcher(url.encodedPath());
        if (m.matches()) {
            AttributeSet set = new AttributeSet((Collection)this.extract(m).entrySet().stream().map(e -> new Attribute((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()));
            set = AttributeSet.merge((AttributeSet[])new AttributeSet[]{set, KubernetesAttributesExtractor.extractQueryParameters(url)});
            LOGGER.debug("fromPath {} : {}", (Object)s, (Object)set);
            return set;
        }
        return new AttributeSet(new Attribute[0]);
    }

    public AttributeSet fromResource(String s) {
        HasMetadata h = KubernetesAttributesExtractor.toKubernetesResource(s);
        if (h != null) {
            return this.extract(h);
        }
        return new AttributeSet(new Attribute[0]);
    }

    public AttributeSet extract(HasMetadata hasMetadata) {
        Optional<CustomResourceDefinitionContext> context;
        AttributeSet metadataAttributes = new AttributeSet(new Attribute[0]);
        String apiVersion = hasMetadata.getApiVersion();
        String kind = hasMetadata.getKind();
        String api = null;
        String version = null;
        if (!Utils.isNullOrEmpty((String)apiVersion)) {
            api = ApiVersionUtil.trimGroup((String)apiVersion);
            version = ApiVersionUtil.trimVersion((String)apiVersion);
            if (!api.equals(apiVersion)) {
                metadataAttributes = metadataAttributes.add(new Attribute[]{new Attribute(API, api)});
            } else {
                api = null;
            }
            metadataAttributes = metadataAttributes.add(new Attribute[]{new Attribute(VERSION, version)});
        }
        if (!Utils.isNullOrEmpty((String)hasMetadata.getMetadata().getName())) {
            metadataAttributes = metadataAttributes.add(new Attribute[]{new Attribute(NAME, hasMetadata.getMetadata().getName())});
            metadataAttributes = metadataAttributes.add(new Attribute[]{new Attribute(METADATA_NAME, hasMetadata.getMetadata().getName())});
        }
        if (!Utils.isNullOrEmpty((String)hasMetadata.getMetadata().getNamespace())) {
            metadataAttributes = metadataAttributes.add(new Attribute[]{new Attribute(NAMESPACE, hasMetadata.getMetadata().getNamespace())});
            metadataAttributes = metadataAttributes.add(new Attribute[]{new Attribute(METADATA_NAMESPACE, hasMetadata.getMetadata().getNamespace())});
        }
        if (hasMetadata.getMetadata().getLabels() != null) {
            for (Map.Entry label : hasMetadata.getMetadata().getLabels().entrySet()) {
                metadataAttributes = metadataAttributes.add(new Attribute[]{new Attribute(LABEL_KEY_PREFIX + (String)label.getKey(), (String)label.getValue())});
            }
        }
        if (!(hasMetadata instanceof GenericKubernetesResource)) {
            metadataAttributes = metadataAttributes.add(new Attribute[]{new Attribute(PLURAL, hasMetadata.getPlural())});
        } else if (this.customResourceDefinitionProcessor != null && (context = this.customResourceDefinitionProcessor.findCrd(api, version, kind)).isPresent()) {
            metadataAttributes = metadataAttributes.add(new Attribute[]{new Attribute(PLURAL, context.get().getPlural())});
        }
        return metadataAttributes;
    }

    private Map<String, String> extract(Matcher m) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (m.matches()) {
            String namespace;
            String kind;
            String version;
            String api = m.group(1);
            if (api != null) {
                api = api.substring(2);
                attributes.put(API, api);
            }
            if (!Utils.isNullOrEmpty((String)(version = m.group(VERSION)))) {
                attributes.put(VERSION, version);
            }
            if (!Utils.isNullOrEmpty((String)(kind = m.group(KIND)))) {
                attributes.put(PLURAL, kind);
            }
            if (!Utils.isNullOrEmpty((String)(namespace = m.group(NAMESPACE)))) {
                attributes.put(NAMESPACE, namespace);
            }
            try {
                String name = m.group(NAME);
                if (!Utils.isNullOrEmpty((String)name)) {
                    attributes.put(NAME, name);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return attributes;
    }

    private static AttributeSet extractQueryParameters(HttpUrl url) {
        return AttributeSet.merge((AttributeSet[])new AttributeSet[]{KubernetesAttributesExtractor.extractLabelSelector(url), KubernetesAttributesExtractor.extractFieldSelector(url)});
    }

    private static AttributeSet extractLabelSelector(HttpUrl url) {
        AttributeSet attributes = new AttributeSet(new Attribute[0]);
        String labelSelector = url.queryParameter("labelSelector");
        if (labelSelector != null) {
            for (String requirement : labelSelector.split(",")) {
                Attribute label = KubernetesAttributesExtractor.parseLabel(requirement);
                if (label != null) {
                    attributes = attributes.add(new Attribute[]{label});
                    continue;
                }
                LOGGER.warn("Ignoring unsupported label requirement: {}", (Object)requirement);
            }
        }
        return attributes;
    }

    private static AttributeSet extractFieldSelector(HttpUrl url) {
        AttributeSet attributes = new AttributeSet(new Attribute[0]);
        String fieldSelector = url.queryParameter("fieldSelector");
        if (fieldSelector != null) {
            for (String requirement : fieldSelector.split(",")) {
                Attribute field = KubernetesAttributesExtractor.parseField(requirement);
                if (field != null) {
                    attributes = attributes.add(new Attribute[]{field});
                    continue;
                }
                LOGGER.warn("Ignoring unsupported field requirement: {}", (Object)requirement);
            }
        }
        return attributes;
    }

    private static Attribute parseLabel(String label) {
        Matcher m = LABEL_REQUIREMENT_EQUALITY.matcher(label);
        if (m.matches()) {
            return new Attribute(LABEL_KEY_PREFIX + m.group(KEY), m.group(VALUE));
        }
        m = LABEL_REQUIREMENT_NOT_EQUALITY.matcher(label);
        if (m.matches()) {
            return new Attribute(LABEL_KEY_PREFIX + m.group(KEY), m.group(VALUE), AttributeType.WITHOUT);
        }
        m = LABEL_REQUIREMENT_EXISTS.matcher(label);
        if (m.matches()) {
            return new Attribute(LABEL_KEY_PREFIX + m.group(KEY), "", AttributeType.EXISTS);
        }
        m = LABEL_REQUIREMENT_NOT_EXISTS.matcher(label);
        if (m.matches()) {
            return new Attribute(LABEL_KEY_PREFIX + m.group(KEY), "", AttributeType.NOT_EXISTS);
        }
        return null;
    }

    private static Attribute parseField(String field) {
        Matcher m = LABEL_REQUIREMENT_EQUALITY.matcher(field);
        if (m.matches()) {
            return new Attribute(m.group(KEY), m.group(VALUE));
        }
        m = LABEL_REQUIREMENT_NOT_EQUALITY.matcher(field);
        if (m.matches()) {
            return new Attribute(m.group(KEY), m.group(VALUE), AttributeType.WITHOUT);
        }
        m = LABEL_REQUIREMENT_EXISTS.matcher(field);
        if (m.matches()) {
            return new Attribute(m.group(KEY), "", AttributeType.EXISTS);
        }
        m = LABEL_REQUIREMENT_NOT_EXISTS.matcher(field);
        if (m.matches()) {
            return new Attribute(m.group(KEY), "", AttributeType.NOT_EXISTS);
        }
        return null;
    }

    static HasMetadata toKubernetesResource(String s) {
        if (Utils.isNullOrEmpty((String)s)) {
            return null;
        }
        HasMetadata result = (HasMetadata)Serialization.unmarshal((String)s, GenericKubernetesResource.class);
        if (result == null) {
            throw new IllegalArgumentException("Required value: kind is required");
        }
        return result;
    }
}

