/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.ClusterTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ClusterTLSConfigFluent<A extends ClusterTLSConfigFluent<A>>
extends BaseFluent<A> {
    private SafeTLSConfigBuilder client;
    private WebTLSConfigBuilder server;
    private Map<String, Object> additionalProperties;

    public ClusterTLSConfigFluent() {
    }

    public ClusterTLSConfigFluent(ClusterTLSConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterTLSConfig instance) {
        ClusterTLSConfig clusterTLSConfig = instance = instance != null ? instance : new ClusterTLSConfig();
        if (instance != null) {
            this.withClient(instance.getClient());
            this.withServer(instance.getServer());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SafeTLSConfig buildClient() {
        return this.client != null ? this.client.build() : null;
    }

    public A withClient(SafeTLSConfig client) {
        this._visitables.remove("client");
        if (client != null) {
            this.client = new SafeTLSConfigBuilder(client);
            this._visitables.get("client").add(this.client);
        } else {
            this.client = null;
            this._visitables.get("client").remove(this.client);
        }
        return (A)this;
    }

    public boolean hasClient() {
        return this.client != null;
    }

    public ClientNested<A> withNewClient() {
        return new ClientNested(null);
    }

    public ClientNested<A> withNewClientLike(SafeTLSConfig item) {
        return new ClientNested(item);
    }

    public ClientNested<A> editClient() {
        return this.withNewClientLike(Optional.ofNullable(this.buildClient()).orElse(null));
    }

    public ClientNested<A> editOrNewClient() {
        return this.withNewClientLike(Optional.ofNullable(this.buildClient()).orElse(new SafeTLSConfigBuilder().build()));
    }

    public ClientNested<A> editOrNewClientLike(SafeTLSConfig item) {
        return this.withNewClientLike(Optional.ofNullable(this.buildClient()).orElse(item));
    }

    public WebTLSConfig buildServer() {
        return this.server != null ? this.server.build() : null;
    }

    public A withServer(WebTLSConfig server) {
        this._visitables.remove("server");
        if (server != null) {
            this.server = new WebTLSConfigBuilder(server);
            this._visitables.get("server").add(this.server);
        } else {
            this.server = null;
            this._visitables.get("server").remove(this.server);
        }
        return (A)this;
    }

    public boolean hasServer() {
        return this.server != null;
    }

    public ServerNested<A> withNewServer() {
        return new ServerNested(null);
    }

    public ServerNested<A> withNewServerLike(WebTLSConfig item) {
        return new ServerNested(item);
    }

    public ServerNested<A> editServer() {
        return this.withNewServerLike(Optional.ofNullable(this.buildServer()).orElse(null));
    }

    public ServerNested<A> editOrNewServer() {
        return this.withNewServerLike(Optional.ofNullable(this.buildServer()).orElse(new WebTLSConfigBuilder().build()));
    }

    public ServerNested<A> editOrNewServerLike(WebTLSConfig item) {
        return this.withNewServerLike(Optional.ofNullable(this.buildServer()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterTLSConfigFluent that = (ClusterTLSConfigFluent)o;
        if (!Objects.equals(this.client, that.client)) {
            return false;
        }
        if (!Objects.equals(this.server, that.server)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.client, this.server, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.client != null) {
            sb.append("client:");
            sb.append(String.valueOf(this.client) + ",");
        }
        if (this.server != null) {
            sb.append("server:");
            sb.append(String.valueOf(this.server) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServerNested<N>
    extends WebTLSConfigFluent<ServerNested<N>>
    implements Nested<N> {
        WebTLSConfigBuilder builder;

        ServerNested(WebTLSConfig item) {
            this.builder = new WebTLSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterTLSConfigFluent.this.withServer(this.builder.build());
        }

        public N endServer() {
            return this.and();
        }
    }

    public class ClientNested<N>
    extends SafeTLSConfigFluent<ClientNested<N>>
    implements Nested<N> {
        SafeTLSConfigBuilder builder;

        ClientNested(SafeTLSConfig item) {
            this.builder = new SafeTLSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterTLSConfigFluent.this.withClient(this.builder.build());
        }

        public N endClient() {
            return this.and();
        }
    }
}

